/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.architect;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;

public class ArchitectPlacement
extends SimpleAdaptation<Config> {
    private final HashMap<Player, Map<Block, BlockFace>> totalMap = new HashMap();

    public ArchitectPlacement() {
        super("architect-placement");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("architect", "placement", "description"));
        this.setDisplayName(Localizer.dLocalize("architect", "placement", "name"));
        this.setIcon(Material.SCAFFOLDING);
        this.setInterval(360L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + Localizer.dLocalize("architect", "placement", "lore3"));
    }

    private BlockFace getBlockFace(Player player) {
        List list = player.getLastTwoTargetBlocks(null, 5);
        if (list.size() != 2 || !((Block)list.get(1)).getType().isOccluding()) {
            return null;
        }
        Block block = (Block)list.get(1);
        Block block2 = (Block)list.get(0);
        return block.getFace(block2);
    }

    @EventHandler
    public void on(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        this.totalMap.remove(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BlockPlaceEvent blockPlaceEvent) {
        if (blockPlaceEvent.isCancelled()) {
            return;
        }
        Player player = blockPlaceEvent.getPlayer();
        if (this.hasAdaptation(player) && !this.totalMap.isEmpty() && this.totalMap.get(player) != null && this.totalMap.get(player).size() > 0) {
            ItemStack itemStack = player.getInventory().getItemInMainHand().clone();
            ItemStack itemStack2 = player.getInventory().getItemInMainHand();
            if (player.isSneaking() && itemStack.getType().isBlock()) {
                double d = this.getValue(blockPlaceEvent.getBlock());
                int n = itemStack.getAmount() - this.totalMap.get(player).size();
                if (n >= 0) {
                    for (Block block : this.totalMap.get(player).keySet()) {
                        if (!this.canBlockPlace(player, block.getLocation())) {
                            Adapt.verbose("Player " + player.getName() + " doesn't have permission.");
                            continue;
                        }
                        BlockFace blockFace = this.totalMap.get(player).get(block);
                        if (block.getWorld().getBlockAt(block.getRelative(blockFace).getLocation()).getType() == Material.AIR && block.getRelative(blockFace).getLocation() != blockPlaceEvent.getBlock().getLocation()) {
                            block.getWorld().setBlockData(block.getRelative(blockFace).getLocation(), block.getBlockData());
                            this.getPlayer(player).getData().addStat("blocks.placed", 1.0);
                            this.getPlayer(player).getData().addStat("blocks.placed.value", d);
                            player.playSound(block.getLocation(), Sound.BLOCK_AZALEA_BREAK, 0.4f, 0.25f);
                            this.xp(player, 2.0);
                        }
                        itemStack.setAmount(itemStack.getAmount() - 1);
                        itemStack2.setAmount(itemStack.getAmount());
                    }
                    this.totalMap.remove(player);
                    if (itemStack2.getAmount() > 0) {
                        this.runPlayerViewport(this.getBlockFace(player), player.getTargetBlock(null, 5), player.getInventory().getItemInMainHand().getType(), player);
                    }
                    blockPlaceEvent.setCancelled(true);
                } else {
                    Adapt.messagePlayer(player, C.RED + Localizer.dLocalize("architect", "placement", "lore1") + " " + C.GREEN + this.totalMap.get(player).size() + C.RED + " " + Localizer.dLocalize("architect", "placement", "lore2"));
                }
            }
        }
    }

    @EventHandler
    public void on(PlayerToggleSneakEvent playerToggleSneakEvent) {
        if (playerToggleSneakEvent.isCancelled()) {
            return;
        }
        Player player = playerToggleSneakEvent.getPlayer();
        if (this.hasAdaptation(player) && player.isSneaking()) {
            this.totalMap.remove(player);
        }
        if (this.hasAdaptation(player) && !player.isSneaking() && player.getInventory().getItemInMainHand().getType().isBlock()) {
            Block block = player.getTargetBlock(null, 5);
            Material material = player.getInventory().getItemInMainHand().getType();
            if (material.isAir()) {
                return;
            }
            BlockFace blockFace = this.getBlockFace(player);
            this.runPlayerViewport(blockFace, block, material, player);
        }
    }

    @EventHandler
    public void on(PlayerMoveEvent playerMoveEvent) {
        if (playerMoveEvent.isCancelled()) {
            return;
        }
        Player player = playerMoveEvent.getPlayer();
        if (this.hasAdaptation(player) && !player.isSneaking()) {
            this.totalMap.remove(player);
        }
        if (this.hasAdaptation(player) && player.isSneaking() && player.getInventory().getItemInMainHand().getType().isBlock()) {
            Block block = player.getTargetBlock(null, 5);
            Material material = player.getInventory().getItemInMainHand().getType();
            if (material.isAir()) {
                return;
            }
            BlockFace blockFace = this.getBlockFace(player);
            this.runPlayerViewport(blockFace, block, material, player);
        }
    }

    public void runPlayerViewport(BlockFace blockFace, Block block, Material material, Player player) {
        block10: {
            block11: {
                block9: {
                    if (blockFace == null || !blockFace.getDirection().equals((Object)BlockFace.NORTH.getDirection()) && !blockFace.getDirection().equals((Object)BlockFace.SOUTH.getDirection())) break block9;
                    for (int i = block.getX() - 1; i <= block.getX() + 1; ++i) {
                        for (int j = block.getY() - 1; j <= block.getY() + 1; ++j) {
                            if (material != block.getWorld().getBlockAt(i, j, block.getZ()).getType()) continue;
                            if (this.totalMap.get(player) == null) {
                                HashMap<Block, BlockFace> hashMap = new HashMap<Block, BlockFace>();
                                hashMap.put(block.getWorld().getBlockAt(i, j, block.getZ()), blockFace);
                                this.totalMap.put(player, hashMap);
                                continue;
                            }
                            if (this.totalMap.get(player).size() > ((Config)this.getConfig()).maxBlocks) continue;
                            this.totalMap.get(player).put(block.getWorld().getBlockAt(i, j, block.getZ()), blockFace);
                        }
                    }
                    break block10;
                }
                if (blockFace == null || !blockFace.getDirection().equals((Object)BlockFace.EAST.getDirection()) && !blockFace.getDirection().equals((Object)BlockFace.WEST.getDirection())) break block11;
                for (int i = block.getZ() - 1; i <= block.getZ() + 1; ++i) {
                    for (int j = block.getY() - 1; j <= block.getY() + 1; ++j) {
                        if (material != block.getWorld().getBlockAt(block.getX(), j, i).getType()) continue;
                        if (this.totalMap.get(player) == null) {
                            HashMap<Block, BlockFace> hashMap = new HashMap<Block, BlockFace>();
                            hashMap.put(block.getWorld().getBlockAt(block.getX(), j, i), blockFace);
                            this.totalMap.put(player, hashMap);
                            continue;
                        }
                        if (this.totalMap.get(player).size() > ((Config)this.getConfig()).maxBlocks) continue;
                        this.totalMap.get(player).put(block.getWorld().getBlockAt(block.getX(), j, i), blockFace);
                    }
                }
                break block10;
            }
            if (blockFace == null || !blockFace.getDirection().equals((Object)BlockFace.UP.getDirection()) && !blockFace.getDirection().equals((Object)BlockFace.DOWN.getDirection())) break block10;
            for (int i = block.getZ() - 1; i <= block.getZ() + 1; ++i) {
                for (int j = block.getX() - 1; j <= block.getX() + 1; ++j) {
                    if (material != block.getWorld().getBlockAt(j, block.getY(), i).getType()) continue;
                    if (this.totalMap.get(player) == null) {
                        HashMap<Block, BlockFace> hashMap = new HashMap<Block, BlockFace>();
                        hashMap.put(block.getWorld().getBlockAt(j, block.getY(), i), blockFace);
                        this.totalMap.put(player, hashMap);
                        continue;
                    }
                    if (this.totalMap.get(player).size() > ((Config)this.getConfig()).maxBlocks) continue;
                    this.totalMap.get(player).put(block.getWorld().getBlockAt(j, block.getY(), i), blockFace);
                }
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    @Override
    public void onTick() {
        if (!this.totalMap.isEmpty()) {
            J.a(() -> {
                for (Player player : this.totalMap.keySet()) {
                    if (!this.hasAdaptation(player) || !player.isSneaking()) {
                        this.totalMap.clear();
                        return;
                    }
                    Map<Block, BlockFace> map = this.totalMap.get(player);
                    for (Block block : map.keySet()) {
                        BlockFace blockFace = map.get(block);
                        Block block2 = block.getRelative(blockFace);
                        if (!((Config)this.getConfig()).showParticles) continue;
                        this.vfxCuboidOutline(block2, Particle.REVERSE_PORTAL);
                    }
                }
            });
        }
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        public int maxBlocks = 20;
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 6;
        int maxLevel = 1;
        int initialCost = 4;
        double costFactor = 2.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

