/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.architect;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.api.adaptation.chunk.ChunkLoading;
import com.volmit.adapt.api.recipe.AdaptRecipe;
import com.volmit.adapt.content.item.BoundRedstoneTorch;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.AnaloguePowerable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class ArchitectWirelessRedstone
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> cooldowns;

    public ArchitectWirelessRedstone() {
        super("architect-wireless-redstone");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("architect", "wirelessredstone", "description"));
        this.setDisplayName(Localizer.dLocalize("architect", "wirelessredstone", "name"));
        this.setIcon(Material.REDSTONE_TORCH);
        this.setInterval(100L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.registerRecipe(AdaptRecipe.shapeless().key("remote-redstone-torch").ingredient(Material.REDSTONE_TORCH).ingredient(Material.TARGET).ingredient(Material.ENDER_PEARL).result(BoundRedstoneTorch.io.withData(new BoundRedstoneTorch.Data(null))).build());
        this.cooldowns = new HashMap<Player, Long>();
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + Localizer.dLocalize("architect", "wirelessredstone", "lore1"));
    }

    @EventHandler
    public void onPlayerItemHeld(PlayerItemHeldEvent playerItemHeldEvent) {
        Player player = playerItemHeldEvent.getPlayer();
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        ItemStack itemStack2 = player.getInventory().getItemInOffHand();
        if (this.isRedstoneTorch(itemStack)) {
            this.updateTorchCooldown(player, itemStack);
        }
        if (this.isRedstoneTorch(itemStack2)) {
            this.updateTorchCooldown(player, itemStack2);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent playerInteractEvent) {
        boolean bl;
        Player player = playerInteractEvent.getPlayer();
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        ItemStack itemStack2 = player.getInventory().getItemInOffHand();
        boolean bl2 = this.isRedstoneTorch(itemStack) && this.isBound(itemStack);
        boolean bl3 = bl = this.isRedstoneTorch(itemStack2) && this.isBound(itemStack2);
        if (this.shouldCancelEvent(player, playerInteractEvent, bl2, bl)) {
            playerInteractEvent.setCancelled(true);
            return;
        }
        if (!this.canInteract(playerInteractEvent.getPlayer(), playerInteractEvent.getPlayer().getLocation())) {
            return;
        }
        this.handleOffhandInteraction(playerInteractEvent, player);
        if (bl2) {
            this.handleRedstoneTorchInteraction(playerInteractEvent, player, itemStack);
        }
    }

    private boolean shouldCancelEvent(Player player, PlayerInteractEvent playerInteractEvent, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = this.hasAdaptation(player);
        boolean bl5 = AdaptConfig.get().allowAdaptationsInCreative;
        boolean bl6 = player.getGameMode() == GameMode.CREATIVE;
        boolean bl7 = bl3 = playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK && playerInteractEvent.getHand() == EquipmentSlot.HAND;
        if ((bl || bl2) && (!bl4 && !bl6 || bl4 && !bl5 && bl6)) {
            return bl3 || bl4 && !bl6;
        }
        return false;
    }

    private boolean isRedstoneTorch(ItemStack itemStack) {
        return itemStack.getType().equals((Object)Material.REDSTONE_TORCH);
    }

    private void updateTorchCooldown(Player player, ItemStack itemStack) {
        int n = this.isBound(itemStack) ? 50000 : 0;
        player.setCooldown(Material.REDSTONE_TORCH, n);
    }

    private void handleOffhandInteraction(PlayerInteractEvent playerInteractEvent, Player player) {
        ItemStack itemStack = player.getInventory().getItemInOffHand();
        if (playerInteractEvent.getHand() != null && playerInteractEvent.getHand().equals((Object)EquipmentSlot.OFF_HAND) && BoundRedstoneTorch.isBindableItem(itemStack)) {
            playerInteractEvent.setCancelled(true);
        }
    }

    private void handleRedstoneTorchInteraction(PlayerInteractEvent playerInteractEvent, Player player, ItemStack itemStack) {
        if (BoundRedstoneTorch.isBindableItem(itemStack)) {
            if (!this.hasAdaptation(player)) {
                return;
            }
            Adapt.verbose("Player " + player.getName() + " is holding a bound redstone torch");
            switch (playerInteractEvent.getAction()) {
                case LEFT_CLICK_BLOCK: {
                    this.handleLeftClickBlock(playerInteractEvent, player);
                    break;
                }
                case RIGHT_CLICK_AIR: 
                case RIGHT_CLICK_BLOCK: {
                    this.handleRightClickBlock(playerInteractEvent, player);
                }
            }
        }
    }

    private void handleLeftClickBlock(PlayerInteractEvent playerInteractEvent, Player player) {
        Adapt.verbose("Player " + player.getName() + " is left clicking a block");
        if (player.isSneaking()) {
            if (playerInteractEvent.getClickedBlock() == null) {
                player.playSound(player.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 0.1f, 0.9f);
                return;
            }
            Location location = new Location(playerInteractEvent.getClickedBlock().getWorld(), (double)playerInteractEvent.getClickedBlock().getX(), (double)playerInteractEvent.getClickedBlock().getY(), (double)playerInteractEvent.getClickedBlock().getZ());
            playerInteractEvent.setCancelled(true);
            this.linkTorch(player, location);
        } else {
            playerInteractEvent.setCancelled(false);
        }
    }

    private void handleRightClickBlock(PlayerInteractEvent playerInteractEvent, Player player) {
        Adapt.verbose("Player " + player.getName() + " is right clicking a block");
        if (this.hasCooldown(player)) {
            player.playSound(player.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 0.1f, 0.9f);
        } else {
            this.cooldowns.put(player, System.currentTimeMillis() + (long)((Config)this.getConfig()).cooldown);
            this.triggerPulse(player);
            playerInteractEvent.setCancelled(true);
        }
    }

    private boolean hasCooldown(Player player) {
        if (this.cooldowns.containsKey(player) && M.ms() >= this.cooldowns.get(player)) {
            this.cooldowns.remove(player);
        }
        return this.cooldowns.containsKey(player);
    }

    private void linkTorch(Player player, Location location) {
        if (!location.getBlock().getType().equals((Object)Material.TARGET)) {
            return;
        }
        if (((Config)this.getConfig()).showParticles) {
            this.vfxCuboidOutline(location.getBlock(), location.getBlock(), Color.RED, 1);
        }
        player.getWorld().playSound(location, Sound.BLOCK_CHEST_OPEN, 0.1f, 9.0f);
        player.getWorld().playSound(location, Sound.ENTITY_ENDER_EYE_DEATH, 0.2f, 0.48f);
        ItemStack itemStack2 = player.getInventory().getItemInMainHand();
        if (itemStack2.getAmount() == 1) {
            BoundRedstoneTorch.setData(itemStack2, location);
        } else {
            itemStack2.setAmount(itemStack2.getAmount() - 1);
            ItemStack itemStack3 = BoundRedstoneTorch.withData(location);
            player.getInventory().addItem(new ItemStack[]{itemStack3}).values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
        }
    }

    private void triggerPulse(Player player) {
        Location location = BoundRedstoneTorch.getLocation(player.getInventory().getItemInMainHand());
        if (this.isBound(player.getInventory().getItemInMainHand()) && location != null) {
            ChunkLoading.loadChunkAsync(location, chunk -> {
                Block block = location.getBlock();
                BlockData blockData = block.getBlockData();
                if (blockData instanceof AnaloguePowerable) {
                    AnaloguePowerable analoguePowerable = (AnaloguePowerable)blockData;
                    if (block.getType().equals((Object)Material.TARGET)) {
                        player.getWorld().playSound(location, Sound.BLOCK_CHEST_OPEN, 0.1f, 9.0f);
                        analoguePowerable.setPower(15);
                        this.vfxCuboidOutline(location.getBlock(), location.getBlock(), Color.RED, 1);
                        block.setBlockData((BlockData)analoguePowerable);
                        J.s(() -> {
                            analoguePowerable.setPower(0);
                            block.setBlockData((BlockData)analoguePowerable);
                        }, 2);
                        return;
                    }
                }
                player.playSound(player.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 0.1f, 0.9f);
            });
        }
    }

    private boolean isBound(ItemStack itemStack) {
        return itemStack.getType().equals((Object)Material.REDSTONE_TORCH) && BoundRedstoneTorch.getLocation(itemStack) != null;
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            ItemStack itemStack2 = player.getInventory().getItemInOffHand();
            if (!this.isBound(itemStack)) {
                J.s(() -> player.setCooldown(Material.REDSTONE_TORCH, 0));
                continue;
            }
            J.s(() -> player.setCooldown(Material.REDSTONE_TORCH, 50000));
        }
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        public int cooldown = 125;
        boolean permanent = true;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 5;
        int maxLevel = 1;
        int initialCost = 0;
        double costFactor = 1.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

