/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.discovery;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.VectorMath;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class DiscoveryArmor
extends SimpleAdaptation<Config> {
    public DiscoveryArmor() {
        super("discovery-world-armor");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("discovery", "armor", "description"));
        this.setDisplayName(Localizer.dLocalize("discovery", "armor", "name"));
        this.setIcon(Material.TURTLE_HELMET);
        this.setInterval(1305L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + Localizer.dLocalize("discovery", "armor", "lore1") + C.GRAY + ", " + Localizer.dLocalize("discovery", "armor", "lore2"));
        element.addLore(C.YELLOW + "~ " + Localizer.dLocalize("discovery", "armor", "lore3") + C.BLUE + " +" + (double)n * 0.25);
    }

    public double getArmorPoints(Material material) {
        return Math.log(Math.min(2000.0f, material.getBlastResistance() * material.getBlastResistance())) + Math.log((double)(material.getHardness() < 0.0f ? 50.0f : Math.min(50.0f, material.getHardness() + 25.0f)) * 0.33);
    }

    public double getArmor(Location location, int n) {
        Block block = location.getBlock();
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 5;
        for (int i = -n2; i <= n2; ++i) {
            for (int j = -n2; j <= n2; ++j) {
                for (int k = -n2; k <= n2; ++k) {
                    Block block2 = block.getRelative(i, j, k);
                    if (!(block.getLocation().distanceSquared(block2.getLocation()) <= (double)(n2 * n2)) || block2.getType() == Material.AIR || block2.isLiquid()) continue;
                    d2 += 1.0;
                    double d3 = this.getArmorPoints(block2.getType());
                    if (Double.isNaN(d3) || d3 < 0.0) {
                        d3 = 0.0;
                    }
                    d += d3;
                    if (!(d3 > 2.0) || !M.r(0.005 * d3)) continue;
                    Vector vector = VectorMath.directionNoNormal(location, block2.getLocation().add(0.5, 0.5, 0.5));
                    if (!((Config)this.getConfig()).showParticles) continue;
                    location.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, location.clone().add(0.0, 1.0, 0.0), 0, vector.getX(), vector.getY(), vector.getZ());
                }
            }
        }
        return Math.min(d / d2 * ((double)n / 2.0) * 0.65, 10.0);
    }

    private double getRadius(double d) {
        return d * (double)((Config)this.getConfig()).radiusFactor;
    }

    private double getStrength(double d) {
        return Math.pow(d, ((Config)this.getConfig()).strengthExponent);
    }

    @Override
    public void onTick() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Collection collection;
            AttributeInstance attributeInstance;
            if (player == null || !player.isOnline() || (attributeInstance = player.getAttribute(Attribute.GENERIC_ARMOR)) == null || (collection = attributeInstance.getModifiers()) == null || collection.isEmpty()) continue;
            if (!this.hasAdaptation(player)) {
                for (AttributeModifier attributeModifier : new ArrayList(collection)) {
                    if (!attributeModifier.getName().equals("adapt-discovery-armor")) continue;
                    attributeInstance.removeModifier(attributeModifier);
                }
                continue;
            }
            double d = 0.0;
            double d2 = this.getArmor(player.getLocation(), this.getLevel(player));
            d2 = Double.isNaN(d2) ? 0.0 : d2;
            for (AttributeModifier attributeModifier : new ArrayList(collection)) {
                if (!attributeModifier.getName().equals("adapt-discovery-armor")) continue;
                d = attributeModifier.getAmount();
                d = Double.isNaN(d) ? 0.0 : d;
                attributeInstance.removeModifier(attributeModifier);
            }
            double d3 = M.lerp(d, d2, 0.3);
            d3 = Double.isNaN(d3) ? 0.0 : d3;
            attributeInstance.addModifier(new AttributeModifier("adapt-discovery-armor", d3, AttributeModifier.Operation.ADD_NUMBER));
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        public int radiusFactor = 3;
        public double strengthExponent = 1.25;
        public boolean showParticles = true;
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 2;
        int initialCost = 3;
        double costFactor = 0.3;
        int maxLevel = 3;

        static {
            IBootstrap.dasBoot();
        }
    }
}

