/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.herbalism;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;

public class HerbalismHungryShield
extends SimpleAdaptation<Config> {
    public HerbalismHungryShield() {
        super("herbalism-hungry-shield");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("herbalism", "hungryshield", "description"));
        this.setDisplayName(Localizer.dLocalize("herbalism", "hungryshield", "name"));
        this.setIcon(Material.APPLE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(875L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + Form.pc(this.getEffectiveness(this.getLevelPercent(n)), 0) + C.GRAY + " " + Localizer.dLocalize("herbalism", "hungryshield", "lore1"));
    }

    @Override
    public void onTick() {
    }

    private double getEffectiveness(double d) {
        return Math.min(((Config)this.getConfig()).maxEffectiveness, d * d + ((Config)this.getConfig()).effectivenessBase);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(EntityDamageEvent entityDamageEvent) {
        Player player;
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageEvent.getEntity();
        if (entity instanceof Player && this.hasAdaptation(player = (Player)entity)) {
            double d = this.getEffectiveness(this.getLevelPercent(player));
            double d2 = entityDamageEvent.getDamage() * d;
            double d3 = entityDamageEvent.getDamage() - d2;
            if (this.getPlayer(player).consumeFood(d2, 6)) {
                entityDamageEvent.setDamage(d3 += d2);
                this.xp(player, d3);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 7;
        int maxLevel = 5;
        int initialCost = 14;
        double costFactor = 0.925;
        double effectivenessBase = 0.15;
        double maxEffectiveness = 0.95;

        static {
            IBootstrap.dasBoot();
        }
    }
}

