/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.pickaxe;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.data.BlockData;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class PickaxeChisel
extends SimpleAdaptation<Config> {
    public PickaxeChisel() {
        super("pickaxe-chisel");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("pickaxe", "chisel", "description"));
        this.setDisplayName(Localizer.dLocalize("pickaxe", "chisel", "name"));
        this.setIcon(Material.IRON_NUGGET);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(7433L);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + Form.pc(this.getDropChance(this.getLevelPercent(n)), 0) + C.GRAY + " " + Localizer.dLocalize("pickaxe", "chisel", "lore1"));
        element.addLore(C.RED + "- " + this.getDamagePerBlock(this.getLevelPercent(n)) + C.GRAY + " " + Localizer.dLocalize("pickaxe", "chisel", "lore2"));
    }

    private int getCooldownTime(double d) {
        return ((Config)this.getConfig()).cooldownTime;
    }

    private double getDropChance(double d) {
        return d * ((Config)this.getConfig()).dropChanceFactor + ((Config)this.getConfig()).dropChanceBase;
    }

    private double getBreakChance(double d) {
        return ((Config)this.getConfig()).breakChance;
    }

    private int getDamagePerBlock(double d) {
        return (int)(((Config)this.getConfig()).damagePerBlockBase + ((Config)this.getConfig()).damageFactorInverseMultiplier * (1.0 - d));
    }

    @EventHandler
    public void on(PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        if (playerInteractEvent.getClickedBlock() != null && playerInteractEvent.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && this.isPickaxe(player.getInventory().getItemInMainHand()) && this.hasAdaptation(player)) {
            if (player.getInventory().getItemInMainHand().getEnchantments().containsKey(Enchantment.SILK_TOUCH) || player.getInventory().getItemInMainHand().getEnchantments().containsKey(Enchantment.MENDING)) {
                return;
            }
            if (player.getCooldown(player.getInventory().getItemInMainHand().getType()) > 0) {
                return;
            }
            if (!this.canBlockBreak(player, playerInteractEvent.getClickedBlock().getLocation())) {
                return;
            }
            BlockData blockData = playerInteractEvent.getClickedBlock().getBlockData();
            if (this.isOre(blockData)) {
                player.getLocation().getWorld().playSound(player.getLocation(), Sound.BLOCK_DEEPSLATE_PLACE, 1.25f, 1.4f);
                player.getLocation().getWorld().playSound(player.getLocation(), Sound.BLOCK_METAL_HIT, 1.25f, 1.7f);
                player.setCooldown(player.getInventory().getItemInMainHand().getType(), this.getCooldownTime(this.getLevelPercent(player)));
                this.damageHand(player, this.getDamagePerBlock(this.getLevelPercent(player)));
                Location location = player.rayTraceBlocks(8.0).getHitPosition().toLocation(player.getWorld());
                ItemStack itemStack = this.getDropFor(blockData);
                if (M.r(this.getDropChance(this.getLevelPercent(player)))) {
                    if (((Config)this.getConfig()).showParticles) {
                        playerInteractEvent.getClickedBlock().getWorld().spawnParticle(Particle.ITEM_CRACK, location, 14, 0.1, 0.01, 0.01, 0.1, (Object)itemStack);
                    }
                    player.getLocation().getWorld().playSound(player.getLocation(), Sound.BLOCK_DEEPSLATE_PLACE, 1.25f, 0.787f);
                    player.getLocation().getWorld().playSound(player.getLocation(), Sound.BLOCK_AMETHYST_BLOCK_PLACE, 0.55f, 1.89f);
                    playerInteractEvent.getClickedBlock().getWorld().dropItemNaturally(location.clone().subtract(player.getLocation().getDirection().clone().multiply(0.1)), itemStack);
                } else if (((Config)this.getConfig()).showParticles) {
                    playerInteractEvent.getClickedBlock().getWorld().spawnParticle(Particle.ITEM_CRACK, location, 3, 0.01, 0.01, 0.01, 0.1, (Object)itemStack);
                    playerInteractEvent.getClickedBlock().getWorld().spawnParticle(Particle.BLOCK_CRACK, location, 9, 0.1, 0.1, 0.1, (Object)playerInteractEvent.getClickedBlock().getBlockData());
                }
                if (M.r(this.getBreakChance(this.getLevelPercent(player)))) {
                    player.getLocation().getWorld().playSound(player.getLocation(), Sound.BLOCK_BASALT_BREAK, 1.25f, 0.4f);
                    player.getLocation().getWorld().playSound(player.getLocation(), Sound.BLOCK_DEEPSLATE_PLACE, 1.25f, 0.887f);
                    playerInteractEvent.getClickedBlock().breakNaturally(player.getInventory().getItemInMainHand());
                }
            }
        }
    }

    private ItemStack getDropFor(BlockData blockData) {
        return switch (blockData.getMaterial()) {
            case Material.COAL_ORE, Material.DEEPSLATE_COAL_ORE -> new ItemStack(Material.COAL);
            case Material.COPPER_ORE, Material.DEEPSLATE_COPPER_ORE -> new ItemStack(Material.RAW_COPPER);
            case Material.GOLD_ORE, Material.DEEPSLATE_GOLD_ORE, Material.NETHER_GOLD_ORE -> new ItemStack(Material.RAW_GOLD);
            case Material.IRON_ORE, Material.DEEPSLATE_IRON_ORE -> new ItemStack(Material.RAW_IRON);
            case Material.DIAMOND_ORE, Material.DEEPSLATE_DIAMOND_ORE -> new ItemStack(Material.DIAMOND);
            case Material.LAPIS_ORE, Material.DEEPSLATE_LAPIS_ORE -> new ItemStack(Material.LAPIS_LAZULI);
            case Material.EMERALD_ORE, Material.DEEPSLATE_EMERALD_ORE -> new ItemStack(Material.EMERALD);
            case Material.NETHER_QUARTZ_ORE -> new ItemStack(Material.QUARTZ);
            case Material.REDSTONE_ORE -> new ItemStack(Material.REDSTONE);
            default -> new ItemStack(Material.AIR);
        };
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 6;
        int maxLevel = 7;
        int initialCost = 5;
        double costFactor = 0.4;
        int cooldownTime = 5;
        double dropChanceBase = 0.07;
        double dropChanceFactor = 0.22;
        double breakChance = 0.25;
        double damagePerBlockBase = 1.0;
        double damageFactorInverseMultiplier = 2.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

