/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.pickaxe;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.adaptation.pickaxe.PickaxeAutosmelt;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class PickaxeVeinminer
extends SimpleAdaptation<Config> {
    public PickaxeVeinminer() {
        super("pickaxe-veinminer");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("pickaxe", "veinminer", "description"));
        this.setDisplayName(Localizer.dLocalize("pickaxe", "veinminer", "name"));
        this.setIcon(Material.IRON_PICKAXE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInterval(8484L);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + Localizer.dLocalize("pickaxe", "veinminer", "lore1"));
        element.addLore(C.GREEN + (n + ((Config)this.getConfig()).baseRange) + C.GRAY + " " + Localizer.dLocalize("pickaxe", "veinminer", "lore2"));
        element.addLore(C.ITALIC + Localizer.dLocalize("pickaxe", "veinminer", "lore3"));
    }

    private int getRadius(int n) {
        return n + ((Config)this.getConfig()).baseRange;
    }

    @EventHandler
    public void on(BlockBreakEvent blockBreakEvent) {
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        Player player = blockBreakEvent.getPlayer();
        if (!this.hasAdaptation(player)) {
            return;
        }
        if (!player.isSneaking()) {
            return;
        }
        if (!blockBreakEvent.getBlock().getBlockData().getMaterial().name().endsWith("_ORE") && !blockBreakEvent.getBlock().getType().equals((Object)Material.OBSIDIAN)) {
            return;
        }
        Block block = blockBreakEvent.getBlock();
        HashMap<Location, Block> hashMap = new HashMap<Location, Block>();
        hashMap.put(block.getLocation(), block);
        for (int i = 0; i < this.getRadius(this.getLevel(player)); ++i) {
            for (int j = -i; j <= i; ++j) {
                for (int k = -i; k <= i; ++k) {
                    for (int i2 = -i; i2 <= i; ++i2) {
                        Block block2 = block.getRelative(j, k, i2);
                        if (block2.getType() != block.getType() || !this.canBlockBreak(player, blockBreakEvent.getBlock().getLocation())) continue;
                        hashMap.put(block2.getLocation(), block2);
                    }
                }
            }
        }
        J.s(() -> {
            for (Location location : hashMap.keySet()) {
                if (!this.canBlockBreak(player, location)) {
                    Adapt.verbose("Player " + player.getName() + " doesn't have permission.");
                    continue;
                }
                Block block = blockBreakEvent.getBlock().getWorld().getBlockAt(location);
                if (this.getPlayer(player).getData().getSkillLines() != null && this.getPlayer(player).getData().getSkillLines().get("pickaxe").getAdaptations() != null && this.getPlayer(player).getData().getSkillLines().get("pickaxe").getAdaptations().get("pickaxe-autosmelt") != null && this.getPlayer(player).getData().getSkillLines().get("pickaxe").getAdaptations().get("pickaxe-autosmelt").getLevel() > 0) {
                    if (this.getPlayer(player).getData().getSkillLines() != null && this.getPlayer(player).getData().getSkillLines().get("pickaxe").getAdaptations() != null && this.getPlayer(player).getData().getSkillLines().get("pickaxe").getAdaptations().get("pickaxe-drop-to-inventory") != null && this.getPlayer(player).getData().getSkillLines().get("pickaxe").getAdaptations().get("pickaxe-drop-to-inventory").getLevel() > 0) {
                        PickaxeAutosmelt.autosmeltBlockDTI(block, player);
                        continue;
                    }
                    PickaxeAutosmelt.autosmeltBlock(block, player);
                    continue;
                }
                if (this.getPlayer(player).getData().getSkillLines() != null && this.getPlayer(player).getData().getSkillLines().get("pickaxe").getAdaptations() != null && this.getPlayer(player).getData().getSkillLines().get("pickaxe").getAdaptations().get("pickaxe-drop-to-inventory") != null && this.getPlayer(player).getData().getSkillLines().get("pickaxe").getAdaptations().get("pickaxe-drop-to-inventory").getLevel() > 0) {
                    block.getDrops(player.getInventory().getItemInMainHand(), (Entity)player).forEach(itemStack2 -> {
                        HashMap hashMap = player.getInventory().addItem(new ItemStack[]{itemStack2});
                        hashMap.forEach((n, itemStack) -> player.getWorld().dropItem(player.getLocation(), itemStack));
                    });
                    block.setType(Material.AIR);
                    continue;
                }
                block.breakNaturally(player.getItemInUse());
                blockBreakEvent.getBlock().getWorld().playSound(blockBreakEvent.getBlock().getLocation(), Sound.BLOCK_FUNGUS_BREAK, 0.4f, 0.25f);
                if (!((Config)this.getConfig()).showParticles) continue;
                blockBreakEvent.getBlock().getWorld().spawnParticle(Particle.ASH, blockBreakEvent.getBlock().getLocation().add(0.5, 0.5, 0.5), 25, 0.5, 0.5, 0.5, 0.1);
            }
        });
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 6;
        int maxLevel = 5;
        int initialCost = 4;
        double costFactor = 2.325;
        int baseRange = 2;

        static {
            IBootstrap.dasBoot();
        }
    }
}

