/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.rift;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.api.adaptation.chunk.ChunkLoading;
import com.volmit.adapt.api.recipe.AdaptRecipe;
import com.volmit.adapt.content.item.BoundEnderPearl;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import us.lynuxcraft.deadsilenceiv.advancedchests.AdvancedChestsAPI;

public class RiftAccess
extends SimpleAdaptation<Config> {
    private final Map<Location, List<InventoryView>> activeViewsMap = new ConcurrentHashMap<Location, List<InventoryView>>();

    public RiftAccess() {
        super("rift-access");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("rift", "remoteaccess", "description"));
        this.setDisplayName(Localizer.dLocalize("rift", "remoteaccess", "name"));
        this.setMaxLevel(1);
        this.setIcon(Material.NETHER_STAR);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(1000L);
        this.registerRecipe(AdaptRecipe.shapeless().key("rift-remote-access").ingredient(Material.ENDER_PEARL).ingredient(Material.COMPASS).result(BoundEnderPearl.io.withData(new BoundEnderPearl.Data(null))).build());
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.ITALIC + Localizer.dLocalize("rift", "remoteaccess", "lore1"));
        element.addLore(C.ITALIC + Localizer.dLocalize("rift", "remoteaccess", "lore2"));
        element.addLore(C.ITALIC + Localizer.dLocalize("rift", "remoteaccess", "lore3"));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        ItemStack itemStack2 = player.getInventory().getItemInOffHand();
        Block block = playerInteractEvent.getClickedBlock();
        boolean bl = BoundEnderPearl.isBindableItem(itemStack);
        boolean bl2 = BoundEnderPearl.isBindableItem(itemStack2);
        if (bl2 && playerInteractEvent.getHand() != null && playerInteractEvent.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            playerInteractEvent.setCancelled(true);
            return;
        }
        if (bl) {
            playerInteractEvent.setCancelled(true);
            if (this.hasAdaptation(player)) {
                Adapt.verbose("Player using bound enderpearl.");
                this.handleEnderPearlInteraction(playerInteractEvent, player, block);
            }
        }
    }

    private void handleEnderPearlInteraction(PlayerInteractEvent playerInteractEvent, Player player, Block block) {
        boolean bl;
        boolean bl2 = AdaptConfig.get().allowAdaptationsInCreative;
        boolean bl3 = player.getGameMode() == GameMode.CREATIVE;
        boolean bl4 = player.isSneaking();
        boolean bl5 = bl = bl2 || !bl3;
        if (!bl) {
            Adapt.info("Player " + player.getName() + " tried to use the bound item in creative mode.");
            return;
        }
        switch (playerInteractEvent.getAction()) {
            case LEFT_CLICK_BLOCK: {
                if (!bl4 || !this.isStorage(block.getBlockData())) break;
                if (this.canAccessChest(player, block.getLocation())) {
                    this.linkPearl(player, block, playerInteractEvent);
                    break;
                }
                Adapt.verbose("Player " + player.getName() + " doesn't have permission.");
                break;
            }
            case RIGHT_CLICK_AIR: 
            case RIGHT_CLICK_BLOCK: {
                this.openPearl(player);
                break;
            }
        }
    }

    private void linkPearl(Player player, Block block, PlayerInteractEvent playerInteractEvent) {
        playerInteractEvent.setCancelled(true);
        if (((Config)this.getConfig()).showParticles) {
            this.vfxCuboidOutline(block, Particle.REVERSE_PORTAL);
        }
        ItemStack itemStack2 = player.getInventory().getItemInMainHand();
        player.playSound(player.getLocation(), Sound.BLOCK_ENDER_CHEST_CLOSE, 0.5f, 0.8f);
        if (itemStack2.getAmount() == 1) {
            BoundEnderPearl.setData(itemStack2, block);
        } else {
            itemStack2.setAmount(itemStack2.getAmount() - 1);
            ItemStack itemStack3 = BoundEnderPearl.withData(block);
            player.getInventory().addItem(new ItemStack[]{itemStack3}).values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
        }
    }

    private void openPearl(Player player) {
        Block block = BoundEnderPearl.getBlock(player.getInventory().getItemInMainHand());
        if (block == null || !this.canAccessChest(player, block.getLocation())) {
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
            return;
        }
        ChunkLoading.loadChunkAsync(block.getLocation(), chunk -> {
            if (Bukkit.getPluginManager().isPluginEnabled("AdvancedChests") && AdvancedChestsAPI.getChestManager().getAdvancedChest(block.getLocation()) != null) {
                AdvancedChestsAPI.getChestManager().getAdvancedChest(block.getLocation()).openPage((HumanEntity)player, 1);
                Adapt.verbose("Opening AdvancedChests GUI");
            } else {
                BlockState blockState = block.getState();
                if (blockState instanceof InventoryHolder) {
                    InventoryHolder inventoryHolder = (InventoryHolder)blockState;
                    blockState = player.openInventory(inventoryHolder.getInventory());
                    this.activeViewsMap.computeIfAbsent(block.getLocation(), location -> new ArrayList()).add(blockState);
                }
            }
            player.playSound(player.getLocation(), Sound.PARTICLE_SOUL_ESCAPE, 1.0f, 0.1f);
            player.playSound(player.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 0.1f);
        });
    }

    @Override
    public void onTick() {
        J.s(this::checkActiveViews);
    }

    private void checkActiveViews() {
        Iterator<Map.Entry<Location, List<InventoryView>>> iterator = this.activeViewsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Location, List<InventoryView>> entry = iterator.next();
            this.removeInvalidViews(entry);
            this.removeEntryIfViewsEmpty(iterator, entry);
        }
    }

    private void removeInvalidViews(Map.Entry<Location, List<InventoryView>> entry) {
        List<InventoryView> list = entry.getValue();
        for (int i = list.size() - 1; i >= 0; --i) {
            InventoryView inventoryView = list.get(i);
            if (!this.shouldRemoveView(inventoryView)) continue;
            list.remove(i);
        }
    }

    private boolean shouldRemoveView(InventoryView inventoryView) {
        Location location = inventoryView.getTopInventory().getLocation();
        return !inventoryView.getPlayer().getOpenInventory().equals(inventoryView) || location == null || !this.isStorage(location.getBlock().getBlockData());
    }

    private void removeEntryIfViewsEmpty(Iterator<Map.Entry<Location, List<InventoryView>>> iterator, Map.Entry<Location, List<InventoryView>> entry) {
        List<InventoryView> list = entry.getValue();
        if (list.isEmpty()) {
            iterator.remove();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockBurnEvent blockBurnEvent) {
        if (blockBurnEvent.isCancelled()) {
            return;
        }
        this.invClose(blockBurnEvent.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockPistonRetractEvent blockPistonRetractEvent) {
        if (blockPistonRetractEvent.isCancelled()) {
            return;
        }
        for (Block block : blockPistonRetractEvent.getBlocks()) {
            this.invClose(block);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockPistonExtendEvent blockPistonExtendEvent) {
        if (blockPistonExtendEvent.isCancelled()) {
            return;
        }
        for (Block block : blockPistonExtendEvent.getBlocks()) {
            this.invClose(block);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockExplodeEvent blockExplodeEvent) {
        if (blockExplodeEvent.isCancelled()) {
            return;
        }
        for (Block block : blockExplodeEvent.blockList()) {
            this.invClose(block);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockBreakEvent blockBreakEvent) {
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        this.invClose(blockBreakEvent.getBlock());
    }

    private void invClose(Block block) {
        List<InventoryView> list = this.activeViewsMap.get(block.getLocation());
        if (list != null) {
            for (InventoryView inventoryView : list) {
                inventoryView.getPlayer().closeInventory();
            }
            this.activeViewsMap.remove(block.getLocation());
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 3;
        double costFactor = 0.2;
        int initialCost = 15;

        static {
            IBootstrap.dasBoot();
        }
    }
}

