/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.rift;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.api.recipe.AdaptRecipe;
import com.volmit.adapt.content.adaptation.rift.RiftResist;
import com.volmit.adapt.content.item.BoundEyeOfEnder;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class RiftGate
extends SimpleAdaptation<Config> {
    public RiftGate() {
        super("rift-gate");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("rift", "gate", "description"));
        this.setDisplayName(Localizer.dLocalize("rift", "gate", "name"));
        this.setIcon(Material.END_PORTAL_FRAME);
        this.setBaseCost(0);
        this.setCostFactor(0.0);
        this.setMaxLevel(1);
        this.setInitialCost(30);
        this.setInterval(1322L);
        this.registerRecipe(AdaptRecipe.shapeless().key("rift-recall-gate").ingredient(Material.ENDER_PEARL).ingredient(Material.AMETHYST_SHARD).ingredient(Material.EMERALD).result(BoundEyeOfEnder.io.withData(new BoundEyeOfEnder.Data(null))).build());
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.YELLOW + Localizer.dLocalize("rift", "gate", "lore1"));
        element.addLore(C.RED + Localizer.dLocalize("rift", "gate", "lore2"));
        element.addLore(C.ITALIC + Localizer.dLocalize("rift", "gate", "lore3") + C.UNDERLINE + C.RED + Localizer.dLocalize("rift", "gate", "lore4"));
    }

    @EventHandler
    public void on(PlayerInteractEvent playerInteractEvent) {
        Location location;
        Player player = playerInteractEvent.getPlayer();
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        ItemStack itemStack2 = player.getInventory().getItemInOffHand();
        Location location2 = location = playerInteractEvent.getClickedBlock() == null ? player.getLocation() : playerInteractEvent.getClickedBlock().getLocation();
        if (BoundEyeOfEnder.isBindableItem(itemStack2) && playerInteractEvent.getHand() != null && playerInteractEvent.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            playerInteractEvent.setCancelled(true);
            return;
        }
        if (player.getInventory().getItemInMainHand().getType().equals((Object)Material.ENDER_EYE) && !player.hasCooldown(Material.ENDER_EYE) && this.hasAdaptation(player) && BoundEyeOfEnder.isBindableItem(itemStack)) {
            playerInteractEvent.setCancelled(true);
            Adapt.verbose(" - Player Main hand: " + itemStack.getType());
            switch (playerInteractEvent.getAction()) {
                case LEFT_CLICK_BLOCK: 
                case LEFT_CLICK_AIR: {
                    if (!player.isSneaking()) break;
                    Adapt.verbose("Linking eye");
                    this.linkEye(player, location);
                    break;
                }
                case RIGHT_CLICK_AIR: 
                case RIGHT_CLICK_BLOCK: {
                    if (!this.isBound(itemStack)) break;
                    this.openEye(player);
                }
            }
        }
    }

    private void handleEyeOfEnderInteraction(PlayerInteractEvent playerInteractEvent, Player player, Block block) {
        boolean bl = player.isSneaking();
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        Location location = block == null ? player.getLocation() : block.getLocation();
        switch (playerInteractEvent.getAction()) {
            case LEFT_CLICK_BLOCK: 
            case LEFT_CLICK_AIR: {
                if (!bl) break;
                if (this.isBound(itemStack)) {
                    this.unlinkEye(player);
                    break;
                }
                this.linkEye(player, location);
                break;
            }
            case RIGHT_CLICK_AIR: 
            case RIGHT_CLICK_BLOCK: {
                if (!this.isBound(itemStack)) break;
                this.openEye(player);
                break;
            }
        }
    }

    private boolean isBound(ItemStack itemStack) {
        return itemStack.getType().equals((Object)Material.ENDER_EYE) && BoundEyeOfEnder.getLocation(itemStack) != null;
    }

    private void unlinkEye(Player player) {
        ItemStack itemStack2 = player.getInventory().getItemInMainHand();
        this.decrementItemstack(itemStack2, player);
        ItemStack itemStack3 = new ItemStack(Material.ENDER_EYE);
        player.getInventory().addItem(new ItemStack[]{itemStack3}).values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
    }

    private void linkEye(Player player, Location location) {
        if (((Config)this.getConfig()).showParticles) {
            this.vfxCuboidOutline(location.getBlock(), location.add(0.0, 1.0, 0.0).getBlock(), Particle.REVERSE_PORTAL);
        }
        player.playSound(player.getLocation(), Sound.ENTITY_ENDER_EYE_DEATH, 0.5f, 0.22f);
        ItemStack itemStack2 = player.getInventory().getItemInMainHand();
        if (itemStack2.getAmount() == 1) {
            BoundEyeOfEnder.setData(itemStack2, location);
        } else {
            itemStack2.setAmount(itemStack2.getAmount() - 1);
            ItemStack itemStack3 = BoundEyeOfEnder.withData(location);
            player.getInventory().addItem(new ItemStack[]{itemStack3}).values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
        }
    }

    private void openEye(Player player) {
        Adapt.verbose("Using eye");
        Location location = BoundEyeOfEnder.getLocation(player.getInventory().getItemInMainHand());
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (((Config)this.getConfig()).consumeOnUse) {
            this.xp(player, 75.0);
            this.decrementItemstack(itemStack, player);
        } else if (player.getCooldown(Material.ENDER_EYE) > 0) {
            player.playSound(player.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 1.0f, 1.0f);
            return;
        }
        player.setCooldown(Material.ENDER_EYE, 150);
        if (RiftResist.hasRiftResistPerk(this.getPlayer(player))) {
            RiftResist.riftResistStackAdd(player, 150, 3);
        }
        player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 100, 10, true, false, false));
        player.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 85, 0, true, false, false));
        player.playSound(location, Sound.BLOCK_LODESTONE_PLACE, 1.0f, 0.1f);
        player.playSound(location, Sound.BLOCK_BELL_RESONATE, 1.0f, 0.1f);
        J.a(() -> {
            double d = 2.0;
            double d2 = 0.0;
            Color color = Color.fromBGR((int)0, (int)0, (int)0);
            this.vfxFastRing(player.getLocation(), d, color);
            for (long i = 4000L; i > 0L; i -= 50L) {
                this.vfxFastRing(player.getLocation().add(0.0, d2 += 0.02, 0.0), d *= 0.9, color);
                J.sleep(50L);
            }
        });
        this.vfxLevelUp(player);
        player.playSound(player.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 5.35f, 0.1f);
        J.s(() -> {
            player.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
            this.vfxLevelUp(player);
            player.playSound(player.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 5.35f, 0.1f);
        }, 85);
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean consumeOnUse = true;
        boolean showParticles = true;

        static {
            IBootstrap.dasBoot();
        }
    }
}

