/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.stealth;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class StealthSpeed
extends SimpleAdaptation<Config> {
    public StealthSpeed() {
        super("stealth-speed");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("stealth", "speed", "description"));
        this.setDisplayName(Localizer.dLocalize("stealth", "speed", "name"));
        this.setIcon(Material.MUSHROOM_STEW);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setInterval(2000L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + Form.pc(this.getSpeed(this.getLevelPercent(n)), 0) + C.GRAY + Localizer.dLocalize("stealth", "speed", "lore1"));
    }

    @EventHandler
    public void on(PlayerToggleSneakEvent playerToggleSneakEvent) {
        if (playerToggleSneakEvent.isCancelled()) {
            return;
        }
        Player player = playerToggleSneakEvent.getPlayer();
        double d = this.getLevelPercent(player);
        if (!this.hasAdaptation(player)) {
            return;
        }
        if (d == 0.0) {
            return;
        }
        if (!player.isSneaking()) {
            player.playSound(player.getLocation(), Sound.BLOCK_FUNGUS_BREAK, 1.0f, 0.99f);
            player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 8000, this.getLevel(player), false, false));
        } else {
            player.removePotionEffect(PotionEffectType.SPEED);
        }
    }

    private double getSpeed(double d) {
        return d * ((Config)this.getConfig()).factor;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 2;
        int initialCost = 5;
        double costFactor = 0.6;
        double factor = 1.25;

        static {
            IBootstrap.dasBoot();
        }
    }
}

