/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.sword;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Cuboid;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.RNG;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class SwordsMachete
extends SimpleAdaptation<Config> {
    private final List<Integer> holds = new ArrayList<Integer>();

    public SwordsMachete() {
        super("sword-machete");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("sword", "machete", "description"));
        this.setDisplayName(Localizer.dLocalize("sword", "machete", "name"));
        this.setIcon(Material.IRON_SWORD);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(5234L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + this.getRadius(n) + C.GRAY + " " + Localizer.dLocalize("sword", "machete", "lore1"));
        element.addLore(C.YELLOW + "* " + Form.duration((double)this.getCooldownTime(this.getLevelPercent(n)) * 50.0, 1) + C.GRAY + " " + Localizer.dLocalize("sword", "machete", "lore2"));
        element.addLore(C.RED + "- " + this.getDamagePerBlock(this.getLevelPercent(n)) + C.GRAY + " " + Localizer.dLocalize("sword", "machete", "lore3"));
    }

    public double getRadius(int n) {
        return this.getLevelPercent(n) * ((Config)this.getConfig()).radiusFactor + ((Config)this.getConfig()).radiusBase;
    }

    @EventHandler
    public void on(PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        if (playerInteractEvent.getHand() != null && playerInteractEvent.getHand().equals((Object)EquipmentSlot.HAND) && playerInteractEvent.getAction().equals((Object)Action.LEFT_CLICK_AIR) || playerInteractEvent.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
            int n = 0;
            ItemStack itemStack = playerInteractEvent.getItem();
            if (this.isSword(itemStack) && itemStack != null && !player.hasCooldown(itemStack.getType()) && this.hasAdaptation(player)) {
                Location location = player.getEyeLocation().clone().add(player.getLocation().getDirection().clone().multiply(2.25)).add(0.0, -0.5, 0.0);
                int n2 = this.getLevel(player);
                Cuboid cuboid = new Cuboid(location);
                cuboid = cuboid.expand(Cuboid.CuboidDirection.Up, (int)Math.floor(this.getRadius(n2)));
                cuboid = cuboid.expand(Cuboid.CuboidDirection.Down, (int)Math.floor(this.getRadius(n2)));
                cuboid = cuboid.expand(Cuboid.CuboidDirection.North, (int)Math.round(this.getRadius(n2)));
                cuboid = cuboid.expand(Cuboid.CuboidDirection.South, (int)Math.round(this.getRadius(n2)));
                cuboid = cuboid.expand(Cuboid.CuboidDirection.East, (int)Math.round(this.getRadius(n2)));
                cuboid = cuboid.expand(Cuboid.CuboidDirection.West, (int)Math.round(this.getRadius(n2)));
                if (n > 0) {
                    return;
                }
                for (Block block : cuboid) {
                    if (!M.r(this.getLevelPercent(n2) * 2.8 / block.getLocation().distanceSquared(location)) || !block.getType().equals((Object)Material.TALL_GRASS) && !block.getType().equals((Object)Material.CACTUS) && !block.getType().equals((Object)Material.SUGAR_CANE) && !block.getType().equals((Object)Material.CARROT) && !block.getType().equals((Object)Material.POTATO) && !block.getType().equals((Object)Material.NETHER_WART) && !block.getType().equals((Object)Material.GRASS) && !block.getType().equals((Object)Material.FERN) && !block.getType().equals((Object)Material.LARGE_FERN) && !block.getType().equals((Object)Material.VINE) && !block.getType().equals((Object)Material.ROSE_BUSH) && !block.getType().equals((Object)Material.WITHER_ROSE) && !block.getType().equals((Object)Material.ACACIA_LEAVES) && !block.getType().equals((Object)Material.BIRCH_LEAVES) && !block.getType().equals((Object)Material.DARK_OAK_LEAVES) && !block.getType().equals((Object)Material.JUNGLE_LEAVES) && !block.getType().equals((Object)Material.OAK_LEAVES) && !block.getType().equals((Object)Material.SPRUCE_LEAVES) && !block.getType().equals((Object)Material.BROWN_MUSHROOM) && !block.getType().equals((Object)Material.RED_MUSHROOM) && !block.getType().equals((Object)Material.DEAD_BUSH) && !block.getType().equals((Object)Material.DANDELION) && !block.getType().equals((Object)Material.TALL_SEAGRASS) && !block.getType().equals((Object)Material.SEAGRASS) && !block.getType().equals((Object)Material.WHITE_TULIP) && !block.getType().equals((Object)Material.RED_TULIP) && !block.getType().equals((Object)Material.PINK_TULIP) && !block.getType().equals((Object)Material.ORANGE_TULIP) && !block.getType().equals((Object)Material.LILY_OF_THE_VALLEY) && !block.getType().equals((Object)Material.ALLIUM) && !block.getType().equals((Object)Material.AZURE_BLUET) && !block.getType().equals((Object)Material.SUNFLOWER) && !block.getType().equals((Object)Material.CORNFLOWER) && !block.getType().equals((Object)Material.CHORUS_FLOWER) && !block.getType().equals((Object)Material.BAMBOO) && !block.getType().equals((Object)Material.BAMBOO_SAPLING) && !block.getType().equals((Object)Material.LILAC) && !block.getType().equals((Object)Material.PEONY) && !block.getType().equals((Object)Material.LILY_PAD) && !block.getType().equals((Object)Material.COCOA) && !block.getType().equals((Object)Material.MANGROVE_LEAVES) || !this.canBlockBreak(player, block.getLocation())) continue;
                    BlockBreakEvent blockBreakEvent = new BlockBreakEvent(block, player);
                    Bukkit.getPluginManager().callEvent((Event)blockBreakEvent);
                    if (blockBreakEvent.isCancelled()) continue;
                    ++n;
                    J.s(() -> {
                        block.breakNaturally();
                        player.getWorld().playSound(block.getLocation(), Sound.BLOCK_GRASS_BREAK, 0.4f, (float)Math.random() * 1.85f);
                    }, RNG.r.i(0, this.getMaxLevel() - n2 * 2 + 1));
                }
                if (n > 0) {
                    player.setCooldown(itemStack.getType(), this.getCooldownTime(this.getLevelPercent(n2)));
                    player.getWorld().playSound(player.getEyeLocation(), Sound.ENTITY_PLAYER_ATTACK_SWEEP, 1.0f, (float)(Math.random() / 2.0) + 0.65f);
                    this.damageHand(player, n * this.getDamagePerBlock(this.getLevelPercent(n2)));
                    this.getSkill().xp(player, (double)n * 11.25);
                }
            }
        }
    }

    private int getCooldownTime(double d) {
        return (int)((double)((int)((1.0 - d) * ((Config)this.getConfig()).cooldownTicksSlowest)) + ((Config)this.getConfig()).cooldownTicksBase);
    }

    private int getDamagePerBlock(double d) {
        return (int)(((Config)this.getConfig()).toolDamageBase + ((Config)this.getConfig()).toolDamageInverseLevelFactor * (1.0 - d));
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 4;
        int maxLevel = 3;
        int initialCost = 7;
        double costFactor = 0.225;
        double radiusBase = 0.6;
        double radiusFactor = 2.36;
        double cooldownTicksBase = 7.0;
        double cooldownTicksSlowest = 35.0;
        double toolDamageBase = 1.0;
        double toolDamageInverseLevelFactor = 5.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

