/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.tragoul;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class TragoulGlobe
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> cooldowns;

    public TragoulGlobe() {
        super("tragoul-globe");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("tragoul", "globe", "description"));
        this.setDisplayName(Localizer.dLocalize("tragoul", "globe", "name"));
        this.setIcon(Material.ENDER_PEARL);
        this.setInterval(25000L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.cooldowns = new HashMap<Player, Long>();
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + Localizer.dLocalize("tragoul", "globe", "lore1"));
        element.addLore(C.YELLOW + Localizer.dLocalize("tragoul", "globe", "lore2") + (((Config)this.getConfig()).rangePerLevel * (double)n + ((Config)this.getConfig()).initalRange));
        element.addLore(C.YELLOW + Localizer.dLocalize("tragoul", "globe", "lore3") + ((Config)this.getConfig()).bonusDamagePerLevel * (double)n);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Player player;
        Object object;
        if (entityDamageByEntityEvent.isCancelled() || !((object = entityDamageByEntityEvent.getDamager()) instanceof Player) || !this.hasAdaptation(player = (Player)object)) {
            return;
        }
        object = this.cooldowns.get(player);
        if (object != null && (double)((Long)object).longValue() + 1000.0 * ((Config)this.getConfig()).cooldown > (double)System.currentTimeMillis()) {
            return;
        }
        this.cooldowns.put(player, System.currentTimeMillis());
        double d = ((Config)this.getConfig()).rangePerLevel * (double)this.getLevel(player) + ((Config)this.getConfig()).initalRange;
        int n = 0;
        for (Entity entity : player.getNearbyEntities(d, d, d)) {
            if (!(entity instanceof LivingEntity) || entity.equals(player)) continue;
            ++n;
        }
        if (n <= 1) {
            return;
        }
        double d2 = entityDamageByEntityEvent.getDamage() / (double)n + ((Config)this.getConfig()).bonusDamagePerLevel * (double)this.getLevel(player);
        entityDamageByEntityEvent.setDamage(d2);
        for (Entity entity : player.getNearbyEntities(d, d, d)) {
            if (!(entity instanceof LivingEntity) || entity.equals(player)) continue;
            ((LivingEntity)entity).damage(d2, (Entity)player);
        }
        if (((Config)this.getConfig()).showParticles) {
            J.s(() -> this.vfxFastSphere(player.getLocation(), d, Color.BLACK, 400));
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 5;
        int maxLevel = 5;
        int initialCost = 5;
        double cooldown = 1.0;
        double rangePerLevel = 3.0;
        double initalRange = 5.0;
        double costFactor = 1.1;
        double bonusDamagePerLevel = 1.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

