/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.adaptation.blocking.BlockingChainArmorer;
import com.volmit.adapt.content.adaptation.blocking.BlockingHorseArmorer;
import com.volmit.adapt.content.adaptation.blocking.BlockingMultiArmor;
import com.volmit.adapt.content.adaptation.blocking.BlockingSaddlecrafter;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class SkillBlocking
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillBlocking() {
        super("blocking", Localizer.dLocalize("skill", "blocking", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.DARK_GRAY);
        this.setDescription(Localizer.dLocalize("skill", "blocking", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "blocking", "name"));
        this.setInterval(5000L);
        this.setIcon(Material.SHIELD);
        this.registerAdaptation(new BlockingMultiArmor());
        this.registerAdaptation(new BlockingChainArmorer());
        this.registerAdaptation(new BlockingSaddlecrafter());
        this.registerAdaptation(new BlockingHorseArmorer());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.LEATHER_CHESTPLATE).key("challenge_block_1k").title(Localizer.dLocalize("advancement", "challenge_block_1k", "title")).description(Localizer.dLocalize("advancement", "challenge_block_1k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.CHAINMAIL_CHESTPLATE).key("challenge_block_5k").title(Localizer.dLocalize("advancement", "challenge_block_5k", "title")).description(Localizer.dLocalize("advancement", "challenge_block_5k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.IRON_CHESTPLATE).key("challenge_block_50k").title(Localizer.dLocalize("advancement", "challenge_block_50k", "title")).description(Localizer.dLocalize("advancement", "challenge_block_50k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.GOLDEN_CHESTPLATE).key("challenge_block_500k").title(Localizer.dLocalize("advancement", "challenge_block_500k", "title")).description(Localizer.dLocalize("advancement", "challenge_block_500k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.DIAMOND_CHESTPLATE).key("challenge_block_5m").title(Localizer.dLocalize("advancement", "challenge_block_5m", "title")).description(Localizer.dLocalize("advancement", "challenge_block_5m", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build()).build()).build()).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_block_1k").goal(1000.0).stat("blocked.hits").reward(((Config)this.getConfig()).challengeBlock1kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_block_5k").goal(5000.0).stat("blocked.hits").reward(((Config)this.getConfig()).challengeBlock1kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_block_50k").goal(50000.0).stat("blocked.hits").reward(((Config)this.getConfig()).challengeBlock5kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_block_500k").goal(500000.0).stat("blocked.hits").reward(((Config)this.getConfig()).challengeBlock5kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_block_5m").goal(5000000.0).stat("blocked.hits").reward(((Config)this.getConfig()).challengeBlock5kReward).build());
        this.cooldowns = new HashMap<Player, Long>();
    }

    private void handleCooldown(Player player, Runnable runnable) {
        if (this.cooldowns.containsKey(player)) {
            if (this.cooldowns.get(player) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                return;
            }
            this.cooldowns.remove(player);
        }
        this.cooldowns.put(player, System.currentTimeMillis());
        runnable.run();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.shouldReturnForPlayer(player, (Cancellable)entityDamageByEntityEvent, () -> {
                if (player.isBlocking()) {
                    AdaptPlayer adaptPlayer = this.getPlayer(player);
                    adaptPlayer.getData().addStat("blocked.hits", 1.0);
                    adaptPlayer.getData().addStat("blocked.damage", entityDamageByEntityEvent.getDamage());
                    this.handleCooldown(player, () -> {
                        this.xp(player, ((Config)this.getConfig()).xpOnBlockedAttack);
                        player.playSound(player.getLocation(), Sound.BLOCK_IRON_DOOR_CLOSE, 0.5f, 0.77f);
                        player.playSound(player.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 0.5f, 0.77f);
                    });
                }
            });
        }
    }

    @Override
    public void onTick() {
        if (!this.isEnabled()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            AdaptPlayer adaptPlayer = this.getPlayer(player);
            this.shouldReturnForPlayer(player, () -> {
                this.checkStatTrackers(adaptPlayer);
                if (player.getPlayer() != null && (player.getPlayer().getInventory().getItemInOffHand().getType().equals((Object)Material.SHIELD) || player.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)Material.SHIELD))) {
                    this.xpSilent(player, ((Config)this.getConfig()).passiveXpForUsingShield);
                }
            });
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        double xpOnBlockedAttack = 10.0;
        double challengeBlock1kReward = 500.0;
        double challengeBlock5kReward = 2000.0;
        long cooldownDelay = 3000L;
        long passiveXpForUsingShield = 1L;

        static {
            IBootstrap.dasBoot();
        }
    }
}

