/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.adaptation.herbalism.HerbalismCraftableCobweb;
import com.volmit.adapt.content.adaptation.herbalism.HerbalismCraftableMushroomBlocks;
import com.volmit.adapt.content.adaptation.herbalism.HerbalismDropToInventory;
import com.volmit.adapt.content.adaptation.herbalism.HerbalismGrowthAura;
import com.volmit.adapt.content.adaptation.herbalism.HerbalismHungryHippo;
import com.volmit.adapt.content.adaptation.herbalism.HerbalismHungryShield;
import com.volmit.adapt.content.adaptation.herbalism.HerbalismLuck;
import com.volmit.adapt.content.adaptation.herbalism.HerbalismMyconid;
import com.volmit.adapt.content.adaptation.herbalism.HerbalismReplant;
import com.volmit.adapt.content.adaptation.herbalism.HerbalismTerralid;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;

public class SkillHerbalism
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldown = new HashMap<Player, Long>();

    public SkillHerbalism() {
        super("herbalism", Localizer.dLocalize("skill", "herbalism", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.GREEN);
        this.setInterval(3990L);
        this.setDescription(Localizer.dLocalize("skill", "herbalism", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "herbalism", "name"));
        this.setIcon(Material.WHEAT);
        this.registerAdaptation(new HerbalismGrowthAura());
        this.registerAdaptation(new HerbalismReplant());
        this.registerAdaptation(new HerbalismHungryShield());
        this.registerAdaptation(new HerbalismHungryHippo());
        this.registerAdaptation(new HerbalismDropToInventory());
        this.registerAdaptation(new HerbalismLuck());
        this.registerAdaptation(new HerbalismMyconid());
        this.registerAdaptation(new HerbalismTerralid());
        this.registerAdaptation(new HerbalismCraftableMushroomBlocks());
        this.registerAdaptation(new HerbalismCraftableCobweb());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.COOKED_BEEF).key("challenge_eat_100").title("So much to eat!").description("Eat over 100 Items!").frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.COOKED_BEEF).key("challenge_eat_1000").title("Unquenchable Hunger!").description("Eat over 1,000 Items!").frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.COOKED_BEEF).key("challenge_eat_10000").title("EVERLASTING HUNGER!").description("Eat over 10,000 Items!").frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build()).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_eat_100").goal(100.0).stat("food.eaten").reward(((Config)this.getConfig()).challengeEat100Reward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_eat_1000").goal(1000.0).stat("food.eaten").reward(((Config)this.getConfig()).challengeEat1kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_eat_10000").goal(10000.0).stat("food.eaten").reward(((Config)this.getConfig()).challengeEat1kReward).build());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.COOKED_BEEF).key("challenge_harvest_100").title("Full Harvest").description("Harvest over 100 crops!").frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.COOKED_BEEF).key("challenge_harvest_1000").title("Grand Harvest").description("Harvest 1,000 crops!").frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_harvest_100").goal(100.0).stat("harvest.blocks").reward(((Config)this.getConfig()).challengeHarvest100Reward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_harvest_1000").goal(1000.0).stat("harvest.blocks").reward(((Config)this.getConfig()).challengeHarvest1kReward).build());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        this.cooldown.remove(player);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerItemConsumeEvent playerItemConsumeEvent) {
        if (playerItemConsumeEvent.isCancelled()) {
            return;
        }
        Player player = playerItemConsumeEvent.getPlayer();
        this.shouldReturnForPlayer(playerItemConsumeEvent.getPlayer(), (Cancellable)playerItemConsumeEvent, () -> {
            ItemMeta itemMeta = playerItemConsumeEvent.getItem().getItemMeta();
            if (itemMeta instanceof PotionMeta) {
                PotionMeta potionMeta = (PotionMeta)itemMeta;
                return;
            }
            this.handleHerbCooldown(player, () -> {
                this.xp(player, ((Config)this.getConfig()).foodConsumeXP);
                this.getPlayer(player).getData().addStat("food.eaten", 1.0);
            });
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerShearEntityEvent playerShearEntityEvent) {
        if (playerShearEntityEvent.isCancelled()) {
            return;
        }
        Player player = playerShearEntityEvent.getPlayer();
        this.shouldReturnForPlayer(playerShearEntityEvent.getPlayer(), (Cancellable)playerShearEntityEvent, () -> this.xp(player, playerShearEntityEvent.getEntity().getLocation(), ((Config)this.getConfig()).shearXP));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerHarvestBlockEvent playerHarvestBlockEvent) {
        if (playerHarvestBlockEvent.isCancelled()) {
            return;
        }
        this.shouldReturnForPlayer(playerHarvestBlockEvent.getPlayer(), (Cancellable)playerHarvestBlockEvent, () -> this.handleEvent((Cancellable)playerHarvestBlockEvent, playerHarvestBlockEvent.getPlayer(), playerHarvestBlockEvent.getHarvestedBlock(), "harvest.blocks"));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockPlaceEvent blockPlaceEvent) {
        if (blockPlaceEvent.isCancelled()) {
            return;
        }
        this.shouldReturnForPlayer(blockPlaceEvent.getPlayer(), (Cancellable)blockPlaceEvent, () -> this.handleEvent((Cancellable)blockPlaceEvent, blockPlaceEvent.getPlayer(), blockPlaceEvent.getBlock(), "harvest.planted"));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.isCancelled()) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        this.shouldReturnForPlayer(playerInteractEvent.getPlayer(), (Cancellable)playerInteractEvent, () -> {
            if (playerInteractEvent.useItemInHand().equals((Object)Event.Result.DENY)) {
                return;
            }
            if (playerInteractEvent.getClickedBlock() == null) {
                return;
            }
            if (playerInteractEvent.getClickedBlock().getType().equals((Object)Material.COMPOSTER)) {
                this.handleComposterInteraction(playerInteractEvent, player);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockBreakEvent blockBreakEvent) {
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        this.shouldReturnForPlayer(blockBreakEvent.getPlayer(), (Cancellable)blockBreakEvent, () -> this.handleEvent((Cancellable)blockBreakEvent, blockBreakEvent.getPlayer(), blockBreakEvent.getBlock(), "harvest.blocks"));
    }

    private void handleHerbCooldown(Player player, Runnable runnable) {
        if (this.cooldown.containsKey(player)) {
            if ((double)this.cooldown.get(player).longValue() + ((Config)this.getConfig()).harvestXpCooldown > (double)System.currentTimeMillis()) {
                return;
            }
            this.cooldown.remove(player);
        }
        this.cooldown.put(player, System.currentTimeMillis());
        runnable.run();
    }

    private void handleEvent(Cancellable cancellable, Player player, Block block, String string) {
        this.handleHerbCooldown(player, () -> {
            BlockData blockData = block.getBlockData();
            if (blockData instanceof Ageable) {
                Ageable ageable = (Ageable)blockData;
                this.xp(player, block.getLocation().clone().add(0.5, 0.5, 0.5), ((Config)this.getConfig()).harvestPerAgeXP * (double)ageable.getAge());
                this.getPlayer(player).getData().addStat(string, 1.0);
            }
        });
    }

    private void handleComposterInteraction(PlayerInteractEvent playerInteractEvent, Player player) {
        Levelled levelled = (Levelled)playerInteractEvent.getClickedBlock().getBlockData();
        int n = levelled.getLevel();
        J.s(() -> {
            int n2 = ((Levelled)playerInteractEvent.getClickedBlock().getBlockData()).getLevel();
            if (n2 > n || n > 0 && n2 == 0) {
                this.xp(player, playerInteractEvent.getClickedBlock().getLocation().clone().add(0.5, 0.5, 0.5), ((Config)this.getConfig()).composterBaseXP + (double)n2 * ((Config)this.getConfig()).composterLevelXPMultiplier + (n2 == 0 ? ((Config)this.getConfig()).composterNonZeroLevelBonus : 5.0));
                this.getPlayer(player).getData().addStat("harvest.composted", 1.0);
            }
        });
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class Config {
        public boolean enabled = true;
        public double harvestXpCooldown = 5000.0;
        public double foodConsumeXP = 25.0;
        public double shearXP = 25.0;
        public double harvestPerAgeXP = 2.5;
        public double plantCropSeedsXP = 2.5;
        public double composterBaseXP = 2.5;
        public double composterLevelXPMultiplier = 1.25;
        public double composterNonZeroLevelBonus = 25.0;
        public double challengeEat100Reward = 1250.0;
        public double challengeEat1kReward = 6250.0;
        public double challengeHarvest100Reward = 1250.0;
        public double challengeHarvest1kReward = 6250.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

