/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.adaptation.stealth.StealthGhostArmor;
import com.volmit.adapt.content.adaptation.stealth.StealthSight;
import com.volmit.adapt.content.adaptation.stealth.StealthSnatch;
import com.volmit.adapt.content.adaptation.stealth.StealthSpeed;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class SkillStealth
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillStealth() {
        super("stealth", Localizer.dLocalize("skill", "stealth", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.DARK_GRAY);
        this.setInterval(1412L);
        this.setIcon(Material.WITHER_ROSE);
        this.cooldowns = new HashMap<Player, Long>();
        this.setDescription(Localizer.dLocalize("skill", "stealth", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "stealth", "name"));
        this.registerAdaptation(new StealthSpeed());
        this.registerAdaptation(new StealthSnatch());
        this.registerAdaptation(new StealthGhostArmor());
        this.registerAdaptation(new StealthSight());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.LEATHER_LEGGINGS).key("challenge_sneak_1k").title("Knee Pain").description("Sneak over a kilometer (1,000 blocks)").frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_sneak_1k").goal(1000.0).stat("move.sneak").reward(((Config)this.getConfig()).challengeSneak1kReward).build());
    }

    @Override
    public void onTick() {
        if (!this.isEnabled()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.shouldReturnForPlayer(player, () -> {
                if (!(!player.isSneaking() || player.isSwimming() || player.isSprinting() || player.isFlying() || player.isGliding() || !player.getGameMode().equals((Object)GameMode.SURVIVAL) && !player.getGameMode().equals((Object)GameMode.ADVENTURE))) {
                    this.xpSilent(player, ((Config)this.getConfig()).sneakXP);
                }
            });
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        double challengeSneak1kReward = 1750.0;
        double sneakXP = 10.5;

        static {
            IBootstrap.dasBoot();
        }
    }
}

