/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.Dimension;
import com.volmit.adapt.util.Direction;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Entity;

public class Cuboid
implements Iterable<Block>,
Cloneable,
ConfigurationSerializable {
    protected final String worldName;
    protected int x1;
    protected int y1;
    protected int z1;
    protected int x2;
    protected int y2;
    protected int z2;

    public Cuboid(Location location, Location location2) {
        if (!location.getWorld().equals(location2.getWorld())) {
            throw new IllegalArgumentException("locations must be on the same world");
        }
        this.worldName = location.getWorld().getName();
        this.x1 = Math.min(location.getBlockX(), location2.getBlockX());
        this.y1 = Math.min(location.getBlockY(), location2.getBlockY());
        this.z1 = Math.min(location.getBlockZ(), location2.getBlockZ());
        this.x2 = Math.max(location.getBlockX(), location2.getBlockX());
        this.y2 = Math.max(location.getBlockY(), location2.getBlockY());
        this.z2 = Math.max(location.getBlockZ(), location2.getBlockZ());
    }

    public Cuboid(Location location) {
        this(location, location);
    }

    public Cuboid(Cuboid cuboid) {
        this(cuboid.getWorld().getName(), cuboid.x1, cuboid.y1, cuboid.z1, cuboid.x2, cuboid.y2, cuboid.z2);
    }

    public Cuboid(World world, int n, int n2, int n3, int n4, int n5, int n6) {
        this.worldName = world.getName();
        this.x1 = Math.min(n, n4);
        this.x2 = Math.max(n, n4);
        this.y1 = Math.min(n2, n5);
        this.y2 = Math.max(n2, n5);
        this.z1 = Math.min(n3, n6);
        this.z2 = Math.max(n3, n6);
    }

    private Cuboid(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        this.worldName = string;
        this.x1 = Math.min(n, n4);
        this.x2 = Math.max(n, n4);
        this.y1 = Math.min(n2, n5);
        this.y2 = Math.max(n2, n5);
        this.z1 = Math.min(n3, n6);
        this.z2 = Math.max(n3, n6);
    }

    public Cuboid(Map<String, Object> map) {
        this.worldName = (String)map.get("worldName");
        this.x1 = (Integer)map.get("x1");
        this.x2 = (Integer)map.get("x2");
        this.y1 = (Integer)map.get("y1");
        this.y2 = (Integer)map.get("y2");
        this.z1 = (Integer)map.get("z1");
        this.z2 = (Integer)map.get("z2");
    }

    public List<Entity> getEntities() {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        for (Chunk chunk : this.getChunks()) {
            for (Entity entity : chunk.getEntities()) {
                if (!this.contains(entity.getLocation())) continue;
                arrayList.add(entity);
            }
        }
        return arrayList;
    }

    public void set(Location location, Location location2) {
        this.x1 = Math.min(location.getBlockX(), location2.getBlockX());
        this.y1 = Math.min(location.getBlockY(), location2.getBlockY());
        this.z1 = Math.min(location.getBlockZ(), location2.getBlockZ());
        this.x2 = Math.max(location.getBlockX(), location2.getBlockX());
        this.y2 = Math.max(location.getBlockY(), location2.getBlockY());
        this.z2 = Math.max(location.getBlockZ(), location2.getBlockZ());
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("worldName", this.worldName);
        hashMap.put("x1", this.x1);
        hashMap.put("y1", this.y1);
        hashMap.put("z1", this.z1);
        hashMap.put("x2", this.x2);
        hashMap.put("y2", this.y2);
        hashMap.put("z2", this.z2);
        return hashMap;
    }

    public Cuboid flatten(int n) {
        return new Cuboid(this.getWorld(), this.x1, n, this.z1, this.x2, n, this.z2);
    }

    public Location getLowerNE() {
        return new Location(this.getWorld(), (double)this.x1, (double)this.y1, (double)this.z1);
    }

    public Location getUpperSW() {
        return new Location(this.getWorld(), (double)this.x2, (double)this.y2, (double)this.z2);
    }

    public Location getCenter() {
        int n = this.getUpperX() + 1;
        int n2 = this.getUpperY() + 1;
        int n3 = this.getUpperZ() + 1;
        return new Location(this.getWorld(), (double)this.getLowerX() + (double)(n - this.getLowerX()) / 2.0, (double)this.getLowerY() + (double)(n2 - this.getLowerY()) / 2.0, (double)this.getLowerZ() + (double)(n3 - this.getLowerZ()) / 2.0);
    }

    public World getWorld() {
        World world = Bukkit.getWorld((String)this.worldName);
        if (world == null) {
            throw new IllegalStateException("world '" + this.worldName + "' is not loaded");
        }
        return world;
    }

    public int getSizeX() {
        return this.x2 - this.x1 + 1;
    }

    public int getSizeY() {
        return this.y2 - this.y1 + 1;
    }

    public int getSizeZ() {
        return this.z2 - this.z1 + 1;
    }

    public Dimension getDimension() {
        return new Dimension(this.getSizeX(), this.getSizeY(), this.getSizeZ());
    }

    public int getLowerX() {
        return this.x1;
    }

    public int getLowerY() {
        return this.y1;
    }

    public int getLowerZ() {
        return this.z1;
    }

    public int getUpperX() {
        return this.x2;
    }

    public int getUpperY() {
        return this.y2;
    }

    public int getUpperZ() {
        return this.z2;
    }

    public Block[] corners() {
        Block[] blockArray = new Block[8];
        World world = this.getWorld();
        blockArray[0] = world.getBlockAt(this.x1, this.y1, this.z1);
        blockArray[1] = world.getBlockAt(this.x1, this.y1, this.z2);
        blockArray[2] = world.getBlockAt(this.x1, this.y2, this.z1);
        blockArray[3] = world.getBlockAt(this.x1, this.y2, this.z2);
        blockArray[4] = world.getBlockAt(this.x2, this.y1, this.z1);
        blockArray[5] = world.getBlockAt(this.x2, this.y1, this.z2);
        blockArray[6] = world.getBlockAt(this.x2, this.y2, this.z1);
        blockArray[7] = world.getBlockAt(this.x2, this.y2, this.z2);
        return blockArray;
    }

    public Cuboid expand(CuboidDirection cuboidDirection, int n) {
        switch (cuboidDirection) {
            case North: {
                return new Cuboid(this.worldName, this.x1 - n, this.y1, this.z1, this.x2, this.y2, this.z2);
            }
            case South: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2 + n, this.y2, this.z2);
            }
            case East: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1 - n, this.x2, this.y2, this.z2);
            }
            case West: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2, this.y2, this.z2 + n);
            }
            case Down: {
                return new Cuboid(this.worldName, this.x1, this.y1 - n, this.z1, this.x2, this.y2, this.z2);
            }
            case Up: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2, this.y2 + n, this.z2);
            }
        }
        throw new IllegalArgumentException("invalid direction " + cuboidDirection);
    }

    public Cuboid expand(Direction direction, int n) {
        int n2 = direction.toVector().getBlockX() == 1 ? n : 0;
        int n3 = direction.toVector().getBlockX() == -1 ? -n : 0;
        int n4 = direction.toVector().getBlockY() == 1 ? n : 0;
        int n5 = direction.toVector().getBlockY() == -1 ? -n : 0;
        int n6 = direction.toVector().getBlockZ() == 1 ? n : 0;
        int n7 = direction.toVector().getBlockZ() == -1 ? -n : 0;
        return new Cuboid(this.worldName, this.x1 + n3, this.y1 + n5, this.z1 + n7, this.x2 + n2, this.y2 + n4, this.z2 + n6);
    }

    public Cuboid shift(CuboidDirection cuboidDirection, int n) {
        return this.expand(cuboidDirection, n).expand(cuboidDirection.opposite(), -n);
    }

    public Cuboid outset(CuboidDirection cuboidDirection, int n) {
        return switch (cuboidDirection) {
            case CuboidDirection.Horizontal -> this.expand(CuboidDirection.North, n).expand(CuboidDirection.South, n).expand(CuboidDirection.East, n).expand(CuboidDirection.West, n);
            case CuboidDirection.Vertical -> this.expand(CuboidDirection.Down, n).expand(CuboidDirection.Up, n);
            case CuboidDirection.Both -> this.outset(CuboidDirection.Horizontal, n).outset(CuboidDirection.Vertical, n);
            default -> throw new IllegalArgumentException("invalid direction " + cuboidDirection);
        };
    }

    public Cuboid inset(CuboidDirection cuboidDirection, int n) {
        return this.outset(cuboidDirection, -n);
    }

    public boolean contains(int n, int n2, int n3) {
        return n >= this.x1 && n <= this.x2 && n2 >= this.y1 && n2 <= this.y2 && n3 >= this.z1 && n3 <= this.z2;
    }

    public boolean contains(Block block) {
        return this.contains(block.getLocation());
    }

    public boolean contains(Location location) {
        return this.worldName.equals(location.getWorld().getName()) && this.contains(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public int volume() {
        return this.getSizeX() * this.getSizeY() * this.getSizeZ();
    }

    public byte averageLightLevel() {
        long l = 0L;
        int n = 0;
        for (Block block : this) {
            if (!block.isEmpty()) continue;
            l += (long)block.getLightLevel();
            ++n;
        }
        return n > 0 ? (byte)(l / (long)n) : (byte)0;
    }

    public Cuboid contract() {
        return this.contract(CuboidDirection.Down).contract(CuboidDirection.South).contract(CuboidDirection.East).contract(CuboidDirection.Up).contract(CuboidDirection.North).contract(CuboidDirection.West);
    }

    public Cuboid contract(CuboidDirection cuboidDirection) {
        Cuboid cuboid = this.getFace(cuboidDirection.opposite());
        switch (cuboidDirection) {
            case Down: {
                while (cuboid.containsOnly(Material.AIR) && cuboid.getLowerY() > this.getLowerY()) {
                    cuboid = cuboid.shift(CuboidDirection.Down, 1);
                }
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2, cuboid.getUpperY(), this.z2);
            }
            case Up: {
                while (cuboid.containsOnly(Material.AIR) && cuboid.getUpperY() < this.getUpperY()) {
                    cuboid = cuboid.shift(CuboidDirection.Up, 1);
                }
                return new Cuboid(this.worldName, this.x1, cuboid.getLowerY(), this.z1, this.x2, this.y2, this.z2);
            }
            case North: {
                while (cuboid.containsOnly(Material.AIR) && cuboid.getLowerX() > this.getLowerX()) {
                    cuboid = cuboid.shift(CuboidDirection.North, 1);
                }
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, cuboid.getUpperX(), this.y2, this.z2);
            }
            case South: {
                while (cuboid.containsOnly(Material.AIR) && cuboid.getUpperX() < this.getUpperX()) {
                    cuboid = cuboid.shift(CuboidDirection.South, 1);
                }
                return new Cuboid(this.worldName, cuboid.getLowerX(), this.y1, this.z1, this.x2, this.y2, this.z2);
            }
            case East: {
                while (cuboid.containsOnly(Material.AIR) && cuboid.getLowerZ() > this.getLowerZ()) {
                    cuboid = cuboid.shift(CuboidDirection.East, 1);
                }
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2, this.y2, cuboid.getUpperZ());
            }
            case West: {
                while (cuboid.containsOnly(Material.AIR) && cuboid.getUpperZ() < this.getUpperZ()) {
                    cuboid = cuboid.shift(CuboidDirection.West, 1);
                }
                return new Cuboid(this.worldName, this.x1, this.y1, cuboid.getLowerZ(), this.x2, this.y2, this.z2);
            }
        }
        throw new IllegalArgumentException("Invalid direction " + cuboidDirection);
    }

    public Cuboid getFace(CuboidDirection cuboidDirection) {
        switch (cuboidDirection) {
            case Down: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2, this.y1, this.z2);
            }
            case Up: {
                return new Cuboid(this.worldName, this.x1, this.y2, this.z1, this.x2, this.y2, this.z2);
            }
            case North: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x1, this.y2, this.z2);
            }
            case South: {
                return new Cuboid(this.worldName, this.x2, this.y1, this.z1, this.x2, this.y2, this.z2);
            }
            case East: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2, this.y2, this.z1);
            }
            case West: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z2, this.x2, this.y2, this.z2);
            }
        }
        throw new IllegalArgumentException("Invalid direction " + cuboidDirection);
    }

    public boolean containsOnly(Material material) {
        for (Block block : this) {
            if (block.getType() == material) continue;
            return false;
        }
        return true;
    }

    public Cuboid getBoundingCuboid(Cuboid cuboid) {
        if (cuboid == null) {
            return this;
        }
        int n = Math.min(this.getLowerX(), cuboid.getLowerX());
        int n2 = Math.min(this.getLowerY(), cuboid.getLowerY());
        int n3 = Math.min(this.getLowerZ(), cuboid.getLowerZ());
        int n4 = Math.max(this.getUpperX(), cuboid.getUpperX());
        int n5 = Math.max(this.getUpperY(), cuboid.getUpperY());
        int n6 = Math.max(this.getUpperZ(), cuboid.getUpperZ());
        return new Cuboid(this.worldName, n, n2, n3, n4, n5, n6);
    }

    public Block getRelativeBlock(int n, int n2, int n3) {
        return this.getWorld().getBlockAt(this.x1 + n, this.y1 + n2, this.z1 + n3);
    }

    public Block getRelativeBlock(World world, int n, int n2, int n3) {
        return world.getBlockAt(this.x1 + n, this.y1 + n2, this.z1 + n3);
    }

    public List<Chunk> getChunks() {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        World world = this.getWorld();
        int n = this.getLowerX() & 0xFFFFFFF0;
        int n2 = this.getUpperX() & 0xFFFFFFF0;
        int n3 = this.getLowerZ() & 0xFFFFFFF0;
        int n4 = this.getUpperZ() & 0xFFFFFFF0;
        for (int i = n; i <= n2; i += 16) {
            for (int j = n3; j <= n4; j += 16) {
                arrayList.add(world.getChunkAt(i >> 4, j >> 4));
            }
        }
        return arrayList;
    }

    @Override
    public Iterator<Block> iterator() {
        return new CuboidIterator(this.getWorld(), this.x1, this.y1, this.z1, this.x2, this.y2, this.z2);
    }

    public Cuboid clone() {
        return new Cuboid(this);
    }

    public String toString() {
        return "Cuboid: " + this.worldName + "," + this.x1 + "," + this.y1 + "," + this.z1 + "=>" + this.x2 + "," + this.y2 + "," + this.z2;
    }

    static {
        IBootstrap.dasBoot();
    }

    public static enum CuboidDirection {
        North,
        East,
        South,
        West,
        Up,
        Down,
        Horizontal,
        Vertical,
        Both,
        Unknown;


        public CuboidDirection opposite() {
            switch (this) {
                case North: {
                    return South;
                }
                case East: {
                    return West;
                }
                case South: {
                    return North;
                }
                case West: {
                    return East;
                }
                case Horizontal: {
                    return Vertical;
                }
                case Vertical: {
                    return Horizontal;
                }
                case Up: {
                    return Down;
                }
                case Down: {
                    return Up;
                }
                case Both: {
                    return Both;
                }
            }
            return Unknown;
        }

        static {
            IBootstrap.dasBoot();
        }
    }

    public class CuboidIterator
    implements Iterator<Block> {
        private final World w;
        private final int baseX;
        private final int baseY;
        private final int baseZ;
        private final int sizeX;
        private final int sizeY;
        private final int sizeZ;
        private int x;
        private int y;
        private int z;

        public CuboidIterator(World world, int n, int n2, int n3, int n4, int n5, int n6) {
            this.w = world;
            this.baseX = n;
            this.baseY = n2;
            this.baseZ = n3;
            this.sizeX = Math.abs(n4 - n) + 1;
            this.sizeY = Math.abs(n5 - n2) + 1;
            this.sizeZ = Math.abs(n6 - n3) + 1;
            this.z = 0;
            this.y = 0;
            this.x = 0;
        }

        @Override
        public boolean hasNext() {
            return this.x < this.sizeX && this.y < this.sizeY && this.z < this.sizeZ;
        }

        @Override
        public Block next() {
            Block block = this.w.getBlockAt(this.baseX + this.x, this.baseY + this.y, this.baseZ + this.z);
            if (++this.x >= this.sizeX) {
                this.x = 0;
                if (++this.y >= this.sizeY) {
                    this.y = 0;
                    ++this.z;
                }
            }
            return block;
        }

        @Override
        public void remove() {
        }
    }
}

