/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.Cuboid;
import com.volmit.adapt.util.DOP;
import com.volmit.adapt.util.GBiset;
import com.volmit.adapt.util.VectorMath;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Axis;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public enum Direction {
    U(0, 1, 0, Cuboid.CuboidDirection.Up),
    D(0, -1, 0, Cuboid.CuboidDirection.Down),
    N(0, 0, -1, Cuboid.CuboidDirection.North),
    S(0, 0, 1, Cuboid.CuboidDirection.South),
    E(1, 0, 0, Cuboid.CuboidDirection.East),
    W(-1, 0, 0, Cuboid.CuboidDirection.West);

    private static Map<GBiset<Direction, Direction>, DOP> permute;
    private final int x;
    private final int y;
    private final int z;
    private final Cuboid.CuboidDirection f;

    private Direction(int n2, int n3, int n4, Cuboid.CuboidDirection cuboidDirection) {
        this.x = n2;
        this.y = n3;
        this.z = n4;
        this.f = cuboidDirection;
    }

    public static Direction getDirection(BlockFace blockFace) {
        switch (blockFace) {
            case DOWN: {
                return D;
            }
            case EAST: {
                return E;
            }
            case EAST_NORTH_EAST: {
                return E;
            }
            case EAST_SOUTH_EAST: {
                return E;
            }
            case NORTH: {
                return N;
            }
            case NORTH_EAST: {
                return N;
            }
            case NORTH_NORTH_EAST: {
                return N;
            }
            case NORTH_NORTH_WEST: {
                return N;
            }
            case NORTH_WEST: {
                return N;
            }
            case SELF: {
                return U;
            }
            case SOUTH: {
                return S;
            }
            case SOUTH_EAST: {
                return S;
            }
            case SOUTH_SOUTH_EAST: {
                return S;
            }
            case SOUTH_SOUTH_WEST: {
                return S;
            }
            case SOUTH_WEST: {
                return S;
            }
            case UP: {
                return U;
            }
            case WEST: {
                return W;
            }
            case WEST_NORTH_WEST: {
                return W;
            }
            case WEST_SOUTH_WEST: {
                return W;
            }
        }
        return D;
    }

    public static Direction closest(Vector vector) {
        double d = Double.MAX_VALUE;
        Direction direction = null;
        for (Direction direction2 : Direction.values()) {
            Vector vector2 = direction2.toVector();
            double d2 = vector2.dot(vector);
            if (!(d2 < d)) continue;
            d = d2;
            direction = direction2;
        }
        return direction;
    }

    public static Direction closest(Vector vector, Direction ... directionArray) {
        double d = Double.MAX_VALUE;
        Direction direction = null;
        for (Direction direction2 : directionArray) {
            Vector vector2 = direction2.toVector();
            double d2 = vector2.distance(vector);
            if (!(d2 < d)) continue;
            d = d2;
            direction = direction2;
        }
        return direction;
    }

    public static Direction closest(Vector vector, List<Direction> list) {
        double d = Double.MAX_VALUE;
        Direction direction = null;
        for (Direction direction2 : list) {
            Vector vector2 = direction2.toVector();
            double d2 = vector2.distance(vector);
            if (!(d2 < d)) continue;
            d = d2;
            direction = direction2;
        }
        return direction;
    }

    public static List<Direction> news() {
        ArrayList<Direction> arrayList = new ArrayList<Direction>();
        XList.add(arrayList, N, E, W, S);
        return arrayList;
    }

    public static Direction getDirection(Vector vector) {
        Vector vector2 = VectorMath.triNormalize(vector.clone().normalize());
        for (Direction direction : Direction.udnews()) {
            if (direction.x != vector2.getBlockX() || direction.y != vector2.getBlockY() || direction.z != vector2.getBlockZ()) continue;
            return direction;
        }
        return N;
    }

    public static List<Direction> udnews() {
        ArrayList<Direction> arrayList = new ArrayList<Direction>();
        XList.add(arrayList, U, D, N, E, W, S);
        return arrayList;
    }

    public static Direction fromByte(byte by) {
        if (by > 5 || by < 0) {
            return null;
        }
        if (by == 0) {
            return D;
        }
        if (by == 1) {
            return U;
        }
        if (by == 2) {
            return N;
        }
        if (by == 3) {
            return S;
        }
        if (by == 4) {
            return W;
        }
        return E;
    }

    public static void calculatePermutations() {
        if (permute != null) {
            return;
        }
        permute = new HashMap<GBiset<Direction, Direction>, DOP>();
        for (Direction direction : Direction.udnews()) {
            for (Direction direction2 : Direction.udnews()) {
                GBiset<Direction, Direction> gBiset = new GBiset<Direction, Direction>(direction, direction2);
                if (direction.equals((Object)direction2)) {
                    permute.put(gBiset, new DOP("DIRECT"){

                        @Override
                        public Vector op(Vector vector) {
                            return vector;
                        }
                    });
                    continue;
                }
                if (direction.reverse().equals((Object)direction2)) {
                    if (direction.isVertical()) {
                        permute.put(gBiset, new DOP("R180CCZ"){

                            @Override
                            public Vector op(Vector vector) {
                                return VectorMath.rotate90CCZ(VectorMath.rotate90CCZ(vector));
                            }
                        });
                        continue;
                    }
                    permute.put(gBiset, new DOP("R180CCY"){

                        @Override
                        public Vector op(Vector vector) {
                            return VectorMath.rotate90CCY(VectorMath.rotate90CCY(vector));
                        }
                    });
                    continue;
                }
                if (Direction.getDirection(VectorMath.rotate90CX(direction.toVector())).equals((Object)direction2)) {
                    permute.put(gBiset, new DOP("R90CX"){

                        @Override
                        public Vector op(Vector vector) {
                            return VectorMath.rotate90CX(vector);
                        }
                    });
                    continue;
                }
                if (Direction.getDirection(VectorMath.rotate90CCX(direction.toVector())).equals((Object)direction2)) {
                    permute.put(gBiset, new DOP("R90CCX"){

                        @Override
                        public Vector op(Vector vector) {
                            return VectorMath.rotate90CCX(vector);
                        }
                    });
                    continue;
                }
                if (Direction.getDirection(VectorMath.rotate90CY(direction.toVector())).equals((Object)direction2)) {
                    permute.put(gBiset, new DOP("R90CY"){

                        @Override
                        public Vector op(Vector vector) {
                            return VectorMath.rotate90CY(vector);
                        }
                    });
                    continue;
                }
                if (Direction.getDirection(VectorMath.rotate90CCY(direction.toVector())).equals((Object)direction2)) {
                    permute.put(gBiset, new DOP("R90CCY"){

                        @Override
                        public Vector op(Vector vector) {
                            return VectorMath.rotate90CCY(vector);
                        }
                    });
                    continue;
                }
                if (Direction.getDirection(VectorMath.rotate90CZ(direction.toVector())).equals((Object)direction2)) {
                    permute.put(gBiset, new DOP("R90CZ"){

                        @Override
                        public Vector op(Vector vector) {
                            return VectorMath.rotate90CZ(vector);
                        }
                    });
                    continue;
                }
                if (Direction.getDirection(VectorMath.rotate90CCZ(direction.toVector())).equals((Object)direction2)) {
                    permute.put(gBiset, new DOP("R90CCZ"){

                        @Override
                        public Vector op(Vector vector) {
                            return VectorMath.rotate90CCZ(vector);
                        }
                    });
                    continue;
                }
                permute.put(gBiset, new DOP("FAIL"){

                    @Override
                    public Vector op(Vector vector) {
                        return vector;
                    }
                });
            }
        }
    }

    public String toString() {
        switch (this) {
            case D: {
                return "Down";
            }
            case E: {
                return "East";
            }
            case N: {
                return "North";
            }
            case S: {
                return "South";
            }
            case U: {
                return "Up";
            }
            case W: {
                return "West";
            }
        }
        return "?";
    }

    public boolean isVertical() {
        return this.equals((Object)D) || this.equals((Object)U);
    }

    public Vector toVector() {
        return new Vector(this.x, this.y, this.z);
    }

    public boolean isCrooked(Direction direction) {
        if (this.equals((Object)direction.reverse())) {
            return false;
        }
        return !this.equals((Object)direction);
    }

    public Vector angle(Vector vector, Direction direction) {
        Direction.calculatePermutations();
        for (GBiset<Direction, Direction> gBiset : permute.keySet()) {
            if (!gBiset.getA().equals((Object)this) || !gBiset.getB().equals((Object)direction)) continue;
            return permute.get(gBiset).op(vector);
        }
        return vector;
    }

    public Direction reverse() {
        switch (this) {
            case D: {
                return U;
            }
            case E: {
                return W;
            }
            case N: {
                return S;
            }
            case S: {
                return N;
            }
            case U: {
                return D;
            }
            case W: {
                return E;
            }
        }
        return null;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int z() {
        return this.z;
    }

    public Cuboid.CuboidDirection f() {
        return this.f;
    }

    public byte byteValue() {
        switch (this) {
            case D: {
                return 0;
            }
            case E: {
                return 5;
            }
            case N: {
                return 2;
            }
            case S: {
                return 3;
            }
            case U: {
                return 1;
            }
            case W: {
                return 4;
            }
        }
        return -1;
    }

    public BlockFace getFace() {
        switch (this) {
            case D: {
                return BlockFace.DOWN;
            }
            case E: {
                return BlockFace.EAST;
            }
            case N: {
                return BlockFace.NORTH;
            }
            case S: {
                return BlockFace.SOUTH;
            }
            case U: {
                return BlockFace.UP;
            }
            case W: {
                return BlockFace.WEST;
            }
        }
        return null;
    }

    public Axis getAxis() {
        switch (this) {
            case D: {
                return Axis.Y;
            }
            case E: {
                return Axis.X;
            }
            case N: {
                return Axis.Z;
            }
            case S: {
                return Axis.Z;
            }
            case U: {
                return Axis.Y;
            }
            case W: {
                return Axis.X;
            }
        }
        return null;
    }

    static {
        IBootstrap.dasBoot();
        permute = null;
    }
}

