/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.VoidOutputStream;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class IO {
    public static final char DIR_SEPARATOR_UNIX = '/';
    public static final char DIR_SEPARATOR_WINDOWS = '\\';
    public static final char DIR_SEPARATOR;
    public static final String LINE_SEPARATOR_UNIX = "\n";
    public static final String LINE_SEPARATOR_WINDOWS = "\r\n";
    public static final String LINE_SEPARATOR;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final char[] hexArray;

    public static String decompress(String string) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.getUrlDecoder().decode(string));
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IO.fullTransfer(gZIPInputStream, byteArrayOutputStream, 256);
        gZIPInputStream.close();
        return byteArrayOutputStream.toString(StandardCharsets.UTF_8);
    }

    public static byte[] sdecompress(String string) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.getUrlDecoder().decode(string));
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IO.fullTransfer(gZIPInputStream, byteArrayOutputStream, 256);
        gZIPInputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static String encode(byte[] byArray) {
        return Base64.getUrlEncoder().encodeToString(byArray);
    }

    public static byte[] decode(String string) {
        return Base64.getUrlDecoder().decode(string);
    }

    public static String hash(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            return IO.bytesToHex(messageDigest.digest(string.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return "\u00af\\_(\u30c4)_/\u00af";
        }
    }

    public static String hash(File file) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            DigestInputStream digestInputStream = new DigestInputStream(new FileInputStream(file), messageDigest);
            IO.fullTransfer(digestInputStream, new VoidOutputStream(), 8192);
            digestInputStream.close();
            return IO.bytesToHex(digestInputStream.getMessageDigest().digest());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return "\u00af\\_(\u30c4)_/\u00af";
        }
    }

    public static String bytesToHex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            cArray[i * 2] = hexArray[n >>> 4];
            cArray[i * 2 + 1] = hexArray[n & 0xF];
        }
        return new String(cArray).toUpperCase();
    }

    public static int transfer(InputStream inputStream, OutputStream outputStream, byte[] byArray) {
        int n = inputStream.read(byArray);
        if (n != -1) {
            outputStream.write(byArray, 0, n);
        }
        return n;
    }

    public static long transfer(InputStream inputStream, OutputStream outputStream, int n, long l) {
        long l2 = l;
        long l3 = 0L;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while ((n2 = inputStream.read(byArray, 0, (int)(l2 < (long)n ? l2 : (long)n))) != -1) {
            outputStream.write(byArray, 0, n2);
            l3 += (long)n2;
            if ((l2 -= (long)n2) > 0L) continue;
            break;
        }
        return l3;
    }

    public static long fillTransfer(InputStream inputStream, OutputStream outputStream) {
        return IO.fullTransfer(inputStream, outputStream, 8192);
    }

    public static void deleteUp(File file) {
        if (file.exists()) {
            file.delete();
            if (file.getParentFile().list().length == 0) {
                IO.deleteUp(file.getParentFile());
            }
        }
    }

    public static long fullTransfer(InputStream inputStream, OutputStream outputStream, int n) {
        long l = 0L;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
            l += (long)n2;
        }
        return l;
    }

    public static void delete(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                IO.delete(file2);
            }
        }
        file.delete();
    }

    public static long size(File file) {
        long l = 0L;
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File file2 : file.listFiles()) {
                    l += IO.size(file2);
                }
            } else {
                l += file.length();
            }
        }
        return l;
    }

    public static long count(File file) {
        long l = 0L;
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File file2 : file.listFiles()) {
                    l += IO.count(file2);
                }
            } else {
                ++l;
            }
        }
        return l;
    }

    public static long transfer(InputStream inputStream, OutputStream outputStream, byte[] byArray, int n) {
        long l = n;
        long l2 = 0L;
        int n2 = 0;
        while ((n2 = inputStream.read(byArray, 0, (int)(l < (long)byArray.length ? l : (long)byArray.length))) != -1) {
            outputStream.write(byArray, 0, n2);
            l2 += (long)n2;
            if ((l -= (long)n2) > 0L) continue;
            break;
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readEntry(File file, String string, Consumer<InputStream> consumer) {
        Throwable throwable = null;
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!string.equals(zipEntry.getName())) continue;
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                consumer.accept(inputStream);
            }
        }
        if (throwable != null) {
            throw new IOException("Failed to read zip entry, however it has been closed safely.", throwable);
        }
    }

    public static void writeAll(File file, Object object) {
        file.getParentFile().mkdirs();
        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
        printWriter.println(object.toString());
        printWriter.close();
    }

    public static String readAll(File file) {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        Object object = "";
        String string = "";
        while ((string = bufferedReader.readLine()) != null) {
            object = (String)object + string + LINE_SEPARATOR_UNIX;
        }
        bufferedReader.close();
        return object;
    }

    public static String readAll(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        Object object = "";
        String string = "";
        while ((string = bufferedReader.readLine()) != null) {
            object = (String)object + string + LINE_SEPARATOR_UNIX;
        }
        bufferedReader.close();
        return object;
    }

    public static void touch(File file) {
        if (!file.exists()) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).close();
        }
        file.setLastModified(System.currentTimeMillis());
    }

    public static void copyFile(File file, File file2) {
        IO.copyFile(file, file2, true);
    }

    public static void copyFile(File file, File file2, boolean bl) {
        if (file == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("Source '" + file + "' does not exist");
        }
        if (file.isDirectory()) {
            throw new IOException("Source '" + file + "' exists but is a directory");
        }
        if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
            throw new IOException("Source '" + file + "' and destination '" + file2 + "' are the same");
        }
        if (file2.getParentFile() != null && !file2.getParentFile().exists() && !file2.getParentFile().mkdirs()) {
            throw new IOException("Destination '" + file2 + "' directory cannot be created");
        }
        if (file2.exists() && !file2.canWrite()) {
            throw new IOException("Destination '" + file2 + "' exists but is read-only");
        }
        IO.doCopyFile(file, file2, bl);
    }

    private static void doCopyFile(File file, File file2, boolean bl) {
        if (file2.exists() && file2.isDirectory()) {
            throw new IOException("Destination '" + file2 + "' exists but is a directory");
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);
             FileOutputStream fileOutputStream = new FileOutputStream(file2);){
            IO.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream);
        }
        if (file.length() != file2.length()) {
            throw new IOException("Failed to copy full contents from '" + file + "' to '" + file2 + "'");
        }
        if (bl) {
            file2.setLastModified(file.lastModified());
        }
    }

    public static void closeQuietly(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] toByteArray(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IO.copy(inputStream, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(Reader reader) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IO.copy(reader, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(Reader reader, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IO.copy(reader, byteArrayOutputStream, string);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(String string) {
        return string.getBytes();
    }

    public static char[] toCharArray(InputStream inputStream) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IO.copy(inputStream, (Writer)charArrayWriter);
        return charArrayWriter.toCharArray();
    }

    public static char[] toCharArray(InputStream inputStream, String string) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IO.copy(inputStream, charArrayWriter, string);
        return charArrayWriter.toCharArray();
    }

    public static char[] toCharArray(Reader reader) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IO.copy(reader, (Writer)charArrayWriter);
        return charArrayWriter.toCharArray();
    }

    public static String toString(InputStream inputStream) {
        StringWriter stringWriter = new StringWriter();
        IO.copy(inputStream, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public static String toString(InputStream inputStream, String string) {
        StringWriter stringWriter = new StringWriter();
        IO.copy(inputStream, stringWriter, string);
        return stringWriter.toString();
    }

    public static String toString(Reader reader) {
        StringWriter stringWriter = new StringWriter();
        IO.copy(reader, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public static String toString(byte[] byArray) {
        return new String(byArray);
    }

    public static String toString(byte[] byArray, String string) {
        if (string == null) {
            return new String(byArray);
        }
        return new String(byArray, string);
    }

    public static List<String> readLines(InputStream inputStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return IO.readLines(inputStreamReader);
    }

    public static List<String> readLines(InputStream inputStream, String string) {
        if (string == null) {
            return IO.readLines(inputStream);
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
        return IO.readLines(inputStreamReader);
    }

    public static List<String> readLines(Reader reader) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = bufferedReader.readLine();
        while (string != null) {
            arrayList.add(string);
            string = bufferedReader.readLine();
        }
        return arrayList;
    }

    public static InputStream toInputStream(String string) {
        byte[] byArray = string.getBytes();
        return new ByteArrayInputStream(byArray);
    }

    public static InputStream toInputStream(String string, String string2) {
        byte[] byArray = string2 != null ? string.getBytes(string2) : string.getBytes();
        return new ByteArrayInputStream(byArray);
    }

    public static void write(byte[] byArray, OutputStream outputStream) {
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    public static void write(byte[] byArray, Writer writer) {
        if (byArray != null) {
            writer.write(new String(byArray));
        }
    }

    public static void write(byte[] byArray, Writer writer, String string) {
        if (byArray != null) {
            if (string == null) {
                IO.write(byArray, writer);
            } else {
                writer.write(new String(byArray, string));
            }
        }
    }

    public static void write(char[] cArray, Writer writer) {
        if (cArray != null) {
            writer.write(cArray);
        }
    }

    public static void write(char[] cArray, OutputStream outputStream) {
        if (cArray != null) {
            outputStream.write(new String(cArray).getBytes());
        }
    }

    public static void write(char[] cArray, OutputStream outputStream, String string) {
        if (cArray != null) {
            if (string == null) {
                IO.write(cArray, outputStream);
            } else {
                outputStream.write(new String(cArray).getBytes(string));
            }
        }
    }

    public static void write(String string, Writer writer) {
        if (string != null) {
            writer.write(string);
        }
    }

    public static void write(String string, OutputStream outputStream) {
        if (string != null) {
            outputStream.write(string.getBytes());
        }
    }

    public static void write(String string, OutputStream outputStream, String string2) {
        if (string != null) {
            if (string2 == null) {
                IO.write(string, outputStream);
            } else {
                outputStream.write(string.getBytes(string2));
            }
        }
    }

    public static void write(StringBuffer stringBuffer, Writer writer) {
        if (stringBuffer != null) {
            writer.write(stringBuffer.toString());
        }
    }

    public static void write(StringBuffer stringBuffer, OutputStream outputStream) {
        if (stringBuffer != null) {
            outputStream.write(stringBuffer.toString().getBytes());
        }
    }

    public static void write(StringBuffer stringBuffer, OutputStream outputStream, String string) {
        if (stringBuffer != null) {
            if (string == null) {
                IO.write(stringBuffer, outputStream);
            } else {
                outputStream.write(stringBuffer.toString().getBytes(string));
            }
        }
    }

    public static void writeLines(Collection<String> collection, String string, OutputStream outputStream) {
        if (collection == null) {
            return;
        }
        if (string == null) {
            string = LINE_SEPARATOR;
        }
        for (String string2 : collection) {
            if (string2 != null) {
                outputStream.write(string2.toString().getBytes());
            }
            outputStream.write(string.getBytes());
        }
    }

    public static void writeLines(Collection<String> collection, String string, OutputStream outputStream, String string2) {
        if (string2 == null) {
            IO.writeLines(collection, string, outputStream);
        } else {
            if (collection == null) {
                return;
            }
            if (string == null) {
                string = LINE_SEPARATOR;
            }
            for (String string3 : collection) {
                if (string3 != null) {
                    outputStream.write(string3.toString().getBytes(string2));
                }
                outputStream.write(string.getBytes(string2));
            }
        }
    }

    public static void writeLines(Collection<String> collection, String string, Writer writer) {
        if (collection == null) {
            return;
        }
        if (string == null) {
            string = LINE_SEPARATOR;
        }
        for (String string2 : collection) {
            if (string2 != null) {
                writer.write(string2.toString());
            }
            writer.write(string);
        }
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) {
        long l = IO.copyLarge(inputStream, outputStream);
        if (l > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) {
        byte[] byArray = new byte[4096];
        long l = 0L;
        int n = 0;
        while (-1 != (n = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static void copy(InputStream inputStream, Writer writer) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        IO.copy((Reader)inputStreamReader, writer);
    }

    public static void copy(InputStream inputStream, Writer writer, String string) {
        if (string == null) {
            IO.copy(inputStream, writer);
        } else {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
            IO.copy((Reader)inputStreamReader, writer);
        }
    }

    public static int copy(Reader reader, Writer writer) {
        long l = IO.copyLarge(reader, writer);
        if (l > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l;
    }

    public static long copyLarge(Reader reader, Writer writer) {
        char[] cArray = new char[4096];
        long l = 0L;
        int n = 0;
        while (-1 != (n = reader.read(cArray))) {
            writer.write(cArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static void copy(Reader reader, OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        IO.copy(reader, (Writer)outputStreamWriter);
        outputStreamWriter.flush();
    }

    public static void copy(Reader reader, OutputStream outputStream, String string) {
        if (string == null) {
            IO.copy(reader, outputStream);
        } else {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
            IO.copy(reader, (Writer)outputStreamWriter);
            outputStreamWriter.flush();
        }
    }

    public static boolean contentEquals(InputStream inputStream, InputStream inputStream2) {
        int n;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!(inputStream2 instanceof BufferedInputStream)) {
            inputStream2 = new BufferedInputStream(inputStream2);
        }
        int n2 = inputStream.read();
        while (-1 != n2) {
            n = inputStream2.read();
            if (n2 != n) {
                return false;
            }
            n2 = inputStream.read();
        }
        n = inputStream2.read();
        return n == -1;
    }

    public static boolean contentEquals(Reader reader, Reader reader2) {
        int n;
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        if (!(reader2 instanceof BufferedReader)) {
            reader2 = new BufferedReader(reader2);
        }
        int n2 = reader.read();
        while (-1 != n2) {
            n = reader2.read();
            if (n2 != n) {
                return false;
            }
            n2 = reader.read();
        }
        n = reader2.read();
        return n == -1;
    }

    static {
        IBootstrap.dasBoot();
        DIR_SEPARATOR = File.separatorChar;
        hexArray = "0123456789ABCDEF".toCharArray();
        StringWriter stringWriter = new StringWriter(4);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println();
        LINE_SEPARATOR = stringWriter.toString();
    }
}

