/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Callback;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.ElementEvent;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.MaterialBlock;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class UIElement
implements Element {
    private final String id;
    private final List<String> lore;
    private MaterialBlock material;
    private boolean enchanted;
    private String name;
    private double progress;
    private boolean bg;
    private Callback<Element> eLeft;
    private Callback<Element> eRight;
    private Callback<Element> eShiftLeft;
    private Callback<Element> eShiftRight;
    private Callback<Element> eDraggedInto;
    private Callback<Element> eOtherDraggedInto;
    private int count;

    public UIElement(String string) {
        this.id = string;
        this.lore = new ArrayList<String>();
        this.enchanted = false;
        this.count = 1;
        this.material = new MaterialBlock(Material.AIR);
    }

    @Override
    public MaterialBlock getMaterial() {
        return this.material;
    }

    @Override
    public UIElement setMaterial(MaterialBlock materialBlock) {
        this.material = materialBlock;
        return this;
    }

    public Double clip(double d, double d2, double d3) {
        return Math.min(d3, Math.max(d2, d));
    }

    @Override
    public boolean isEnchanted() {
        return this.enchanted;
    }

    @Override
    public UIElement setEnchanted(boolean bl) {
        this.enchanted = bl;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UIElement setName(String string) {
        this.name = string;
        return this;
    }

    @Override
    public List<String> getLore() {
        return this.lore;
    }

    @Override
    public UIElement onLeftClick(Callback<Element> callback) {
        this.eLeft = callback;
        return this;
    }

    @Override
    public UIElement onRightClick(Callback<Element> callback) {
        this.eRight = callback;
        return this;
    }

    @Override
    public UIElement onShiftLeftClick(Callback<Element> callback) {
        this.eShiftLeft = callback;
        return this;
    }

    @Override
    public UIElement onShiftRightClick(Callback<Element> callback) {
        this.eShiftRight = callback;
        return this;
    }

    @Override
    public UIElement onDraggedInto(Callback<Element> callback) {
        this.eDraggedInto = callback;
        return this;
    }

    @Override
    public UIElement onOtherDraggedInto(Callback<Element> callback) {
        this.eOtherDraggedInto = callback;
        return this;
    }

    @Override
    public Element call(ElementEvent elementEvent, Element element) {
        try {
            switch (elementEvent) {
                case DRAG_INTO: {
                    this.eDraggedInto.run(element);
                    return this;
                }
                case LEFT: {
                    this.eLeft.run(element);
                    return this;
                }
                case OTHER_DRAG_INTO: {
                    this.eOtherDraggedInto.run(element);
                    return this;
                }
                case RIGHT: {
                    this.eRight.run(element);
                    return this;
                }
                case SHIFT_LEFT: {
                    this.eShiftLeft.run(element);
                    return this;
                }
                case SHIFT_RIGHT: {
                    this.eShiftRight.run(element);
                    return this;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this;
    }

    @Override
    public Element addLore(String string) {
        XList.add(this.getLore(), this.wrapWordsWithFormatting(string.replaceAll("\\Q\n\\E", " "), 52).split("\\Q\n\\E"));
        return this;
    }

    public String wrapWordsWithFormatting(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = null;
        for (String string3 : Form.wrapWords(string, n).split("\\Q\n\\E")) {
            if (string2 != null) {
                stringBuilder.append("\n").append(C.getLastColors(string2)).append(string3);
            } else {
                stringBuilder.append("\n").append(string3);
            }
            string2 = string3;
        }
        return stringBuilder.substring(1);
    }

    @Override
    public Element setBackground(boolean bl) {
        this.bg = bl;
        return this;
    }

    @Override
    public boolean isBackgrond() {
        return this.bg;
    }

    @Override
    public Element setCount(int n) {
        this.count = this.clip(n, 1.0, 64.0).intValue();
        return this;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public ItemStack computeItemStack() {
        try {
            ItemStack itemStack = new ItemStack(this.getMaterial().getMaterial(), this.getCount(), this.getEffectiveDurability());
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(this.getName());
            itemMeta.setLore(XList.copy(this.getLore()));
            if (this.isEnchanted()) {
                itemMeta.addEnchant(Enchantment.DURABILITY, 1, true);
            }
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
            itemStack.setItemMeta(itemMeta);
            return itemStack;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    @Override
    public Element setProgress(double d) {
        this.progress = this.clip(d, 0.0, 1.0);
        return this;
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    public short getEffectiveDurability() {
        if (this.progress == 1.0) {
            return 0;
        }
        if (this.getMaterial().getMaterial().getMaxDurability() == 0) {
            return 0;
        }
        int n = (int)((double)this.getMaterial().getMaterial().getMaxDurability() * (1.0 - this.getProgress()));
        return this.clip(n, 1.0, this.getMaterial().getMaterial().getMaxDurability() - 1).shortValue();
    }

    static {
        IBootstrap.dasBoot();
    }
}

