/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.util.Callback;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.ElementEvent;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.UIVoidDecorator;
import com.volmit.adapt.util.Window;
import com.volmit.adapt.util.WindowDecorator;
import com.volmit.adapt.util.WindowResolution;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class UIWindow
implements Window,
Listener {
    private final Player viewer;
    private final Map<Integer, Element> elements;
    private WindowDecorator decorator;
    private Callback<Window> eClose;
    private WindowResolution resolution;
    private String title;
    private boolean visible;
    private int viewportPosition;
    private int viewportSize;
    private int highestRow;
    private String tag;
    private Inventory inventory;
    private int clickcheck = 0;
    private boolean doubleclicked = false;

    public UIWindow(Player player) {
        this.viewer = player;
        this.elements = new HashMap<Integer, Element>();
        this.setTitle("");
        this.setDecorator(new UIVoidDecorator());
        this.setResolution(WindowResolution.W9_H6);
        this.setViewportHeight(this.clip(3.0, 1.0, this.getResolution().getMaxHeight()).intValue());
        this.setViewportPosition(0);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(InventoryClickEvent inventoryClickEvent) {
        if (!inventoryClickEvent.getWhoClicked().equals(this.viewer)) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        if (!this.viewer.getOpenInventory().getTitle().equals(this.title)) {
            return;
        }
        if (inventoryClickEvent.getClickedInventory() == null) {
            return;
        }
        if (!inventoryClickEvent.getView().getType().equals((Object)this.getResolution().getType())) {
            return;
        }
        if (inventoryClickEvent.getClickedInventory().getType().equals((Object)this.getResolution().getType())) {
            Element element = this.getElement(this.getLayoutPosition(inventoryClickEvent.getSlot()), this.getLayoutRow(inventoryClickEvent.getSlot()));
            switch (inventoryClickEvent.getAction()) {
                default: 
            }
            switch (inventoryClickEvent.getClick()) {
                case DOUBLE_CLICK: {
                    this.doubleclicked = true;
                    break;
                }
                case LEFT: {
                    ++this.clickcheck;
                    if (this.clickcheck == 1) {
                        J.s(() -> {
                            if (this.clickcheck == 1) {
                                this.clickcheck = 0;
                                if (element != null) {
                                    element.call(ElementEvent.LEFT, element);
                                }
                            }
                        });
                        break;
                    }
                    if (this.clickcheck != 2) break;
                    J.s(() -> {
                        if (this.doubleclicked) {
                            this.doubleclicked = false;
                        } else {
                            this.scroll(1);
                        }
                        this.clickcheck = 0;
                    });
                    break;
                }
                case RIGHT: {
                    if (element != null) {
                        element.call(ElementEvent.RIGHT, element);
                        break;
                    }
                    this.scroll(-1);
                    break;
                }
                case SHIFT_LEFT: {
                    if (element == null) break;
                    element.call(ElementEvent.SHIFT_LEFT, element);
                    break;
                }
                case SHIFT_RIGHT: {
                    if (element == null) break;
                    element.call(ElementEvent.SHIFT_RIGHT, element);
                    break;
                }
            }
        }
        inventoryClickEvent.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(InventoryCloseEvent inventoryCloseEvent) {
        if (!inventoryCloseEvent.getPlayer().equals(this.viewer)) {
            return;
        }
        if (!inventoryCloseEvent.getPlayer().getOpenInventory().getTitle().equals(this.title)) {
            return;
        }
        if (this.isVisible()) {
            this.close();
            this.callClosed();
        }
    }

    @Override
    public WindowDecorator getDecorator() {
        return this.decorator;
    }

    @Override
    public UIWindow setDecorator(WindowDecorator windowDecorator) {
        this.decorator = windowDecorator;
        return this;
    }

    @Override
    public UIWindow close() {
        this.setVisible(false);
        return this;
    }

    @Override
    public UIWindow open() {
        this.setVisible(true);
        return this;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public UIWindow setVisible(boolean bl) {
        if (this.isVisible() == bl) {
            return this;
        }
        if (bl) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Adapt.instance);
            this.inventory = this.getResolution().getType().equals((Object)InventoryType.CHEST) ? Bukkit.createInventory(null, (int)(this.getViewportHeight() * 9), (String)this.getTitle()) : Bukkit.createInventory(null, (InventoryType)this.getResolution().getType(), (String)this.getTitle());
            this.viewer.openInventory(this.inventory);
            this.visible = bl;
            this.updateInventory();
        } else {
            this.visible = bl;
            HandlerList.unregisterAll((Listener)this);
            this.viewer.closeInventory();
        }
        this.visible = bl;
        return this;
    }

    @Override
    public int getViewportPosition() {
        return this.viewportPosition;
    }

    @Override
    public UIWindow setViewportPosition(int n) {
        this.viewportPosition = n;
        this.scroll(0);
        this.updateInventory();
        return this;
    }

    @Override
    public int getMaxViewportPosition() {
        return Math.max(0, this.highestRow - this.getViewportHeight());
    }

    @Override
    public UIWindow scroll(int n) {
        this.viewportPosition = (int)this.clip(this.viewportPosition + n, 0.0, this.getMaxViewportPosition()).doubleValue();
        this.updateInventory();
        return this;
    }

    @Override
    public int getViewportHeight() {
        return this.viewportSize;
    }

    @Override
    public UIWindow setViewportHeight(int n) {
        this.viewportSize = (int)this.clip(n, 1.0, this.getResolution().getMaxHeight()).doubleValue();
        if (this.isVisible()) {
            this.reopen();
        }
        return this;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public UIWindow setTitle(String string) {
        this.title = string;
        if (this.isVisible()) {
            this.reopen();
        }
        return this;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public void setTag(String string) {
        this.tag = string;
    }

    @Override
    public UIWindow setElement(int n, int n2, Element element) {
        if (n2 > this.highestRow) {
            this.highestRow = n2;
        }
        this.elements.put(this.getRealPosition((int)this.clip(n, -this.getResolution().getMaxWidthOffset(), this.getResolution().getMaxWidthOffset()).doubleValue(), n2), element);
        this.updateInventory();
        return this;
    }

    @Override
    public Element getElement(int n, int n2) {
        return this.elements.get(this.getRealPosition((int)this.clip(n, -this.getResolution().getMaxWidthOffset(), this.getResolution().getMaxWidthOffset()).doubleValue(), n2));
    }

    @Override
    public Player getViewer() {
        return this.viewer;
    }

    @Override
    public UIWindow onClosed(Callback<Window> callback) {
        this.eClose = callback;
        return this;
    }

    @Override
    public int getViewportSlots() {
        return this.getViewportHeight() * this.getResolution().getWidth();
    }

    @Override
    public int getLayoutRow(int n) {
        return this.getRow(this.getRealLayoutPosition(n));
    }

    @Override
    public int getLayoutPosition(int n) {
        return this.getPosition(n);
    }

    @Override
    public int getRealLayoutPosition(int n) {
        return this.getRealPosition(this.getPosition(n), this.getRow(n) + this.getViewportPosition());
    }

    @Override
    public int getRealPosition(int n, int n2) {
        return (int)((double)(n2 * this.getResolution().getWidth() + this.getResolution().getMaxWidthOffset()) + this.clip(n, -this.getResolution().getMaxWidthOffset(), this.getResolution().getMaxWidthOffset()));
    }

    @Override
    public int getRow(int n) {
        return n / this.getResolution().getWidth();
    }

    @Override
    public int getPosition(int n) {
        return n % this.getResolution().getWidth() - this.getResolution().getMaxWidthOffset();
    }

    @Override
    public Window callClosed() {
        if (this.eClose != null) {
            this.eClose.run(this);
        }
        return this;
    }

    @Override
    public boolean hasElement(int n, int n2) {
        return this.getElement(n, n2) != null;
    }

    @Override
    public WindowResolution getResolution() {
        return this.resolution;
    }

    public Double clip(double d, double d2, double d3) {
        return Math.min(d3, Math.max(d2, d));
    }

    @Override
    public Window setResolution(WindowResolution windowResolution) {
        this.close();
        this.resolution = windowResolution;
        this.setViewportHeight((int)this.clip(this.getViewportHeight(), 1.0, this.getResolution().getMaxHeight()).doubleValue());
        return this;
    }

    @Override
    public Window clearElements() {
        this.highestRow = 0;
        this.elements.clear();
        this.updateInventory();
        return this;
    }

    @Override
    public Window updateInventory() {
        if (this.isVisible()) {
            ItemStack[] itemStackArray = this.inventory.getContents();
            HashSet<ItemStack> hashSet = new HashSet<ItemStack>();
            for (int i = 0; i < itemStackArray.length; ++i) {
                ItemStack itemStack = itemStackArray[i];
                ItemStack itemStack2 = this.computeItemStack(i);
                int n = this.getLayoutRow(i);
                int n2 = this.getLayoutPosition(i);
                if (itemStack2 != null && !this.hasElement(n2, n)) {
                    ItemStack itemStack3 = itemStack2.clone();
                    itemStack3.setAmount(itemStack3.getAmount() + 1);
                    hashSet.add(itemStack3);
                }
                if (itemStack == null == (itemStack2 == null) && (itemStack2 == null || itemStack == null || itemStack.equals((Object)itemStack2))) continue;
                this.inventory.setItem(i, itemStack2);
            }
        }
        return this;
    }

    @Override
    public ItemStack computeItemStack(int n) {
        Element element;
        int n2 = this.getLayoutRow(n);
        int n3 = this.getLayoutPosition(n);
        Element element2 = element = this.hasElement(n3, n2) ? this.getElement(n3, n2) : this.getDecorator().onDecorateBackground(this, n3, n2);
        if (element != null) {
            return element.computeItemStack();
        }
        return null;
    }

    @Override
    public Window reopen() {
        return this.close().open();
    }

    static {
        IBootstrap.dasBoot();
    }
}

