/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.util.Control;
import com.volmit.adapt.util.IController;
import com.volmit.adapt.util.IO;
import com.volmit.adapt.util.Instance;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class VolmitPlugin
extends JavaPlugin
implements Listener {
    public static boolean bad;
    private Map<String, IController> controllers;
    private List<IController> cachedControllers;
    private Map<Class<? extends IController>, IController> cachedClassControllers;

    public void l(Object object) {
        Adapt.info("[" + this.getName() + "]: " + object);
    }

    public void w(Object object) {
        Adapt.warn("[" + this.getName() + "]: " + object);
    }

    public void f(Object object) {
        Adapt.error("[" + this.getName() + "]: " + object);
    }

    public void v(Object object) {
        Adapt.verbose("[" + this.getName() + "]: " + object);
    }

    public void onEnable() {
        VolmitPlugin.loadConfig0();
        this.registerInstance();
        this.registerControllers();
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, this::tickControllers, 0L, 0L);
        J.a(this::outputInfo);
        this.registerListener(this);
        this.start();
    }

    public void unregisterAll() {
        try {
            this.stopControllers();
            this.unregisterListeners();
            this.unregisterInstance();
        }
        catch (Exception exception) {
            Adapt.error("Adapt: Failed to unregister all, You have a plugin that is not unloading properly. This is a bug in that plugin. Please report it to the developer. This is on shutdown however, so it's not a big deal.");
            Adapt.error("Adapt: This is not a bug in Adapt. This is a bug in another plugin. Adapt is unloading ALL Command Nodes with Adapt ID's, If another plugin is unloading all or some of these nodes, it will cause this error.");
        }
    }

    private void outputInfo() {
        try {
            IO.delete(this.getDataFolder("info"));
            this.getDataFolder("info").mkdirs();
            this.outputPluginInfo();
        }
        catch (Throwable throwable) {
            Adapt.verbose("Failed to output info");
        }
    }

    private void outputPluginInfo() {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        yamlConfiguration.set("version", (Object)this.getDescription().getVersion());
        yamlConfiguration.set("name", (Object)this.getDescription().getName());
        yamlConfiguration.save(this.getDataFile("info", "plugin.yml"));
    }

    public void onDisable() {
        this.stop();
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        this.unregisterListener(this);
        this.unregisterAll();
    }

    private void tickControllers() {
        if (bad) {
            return;
        }
        for (IController iController : this.getControllers()) {
            this.tickController(iController);
        }
    }

    private void tickController(IController iController) {
        if (bad) {
            return;
        }
        if (iController.getTickInterval() < 0) {
            return;
        }
        ++M.tick;
        if (M.interval(iController.getTickInterval())) {
            try {
                iController.tick();
            }
            catch (Throwable throwable) {
                this.w("Failed to tick controller " + iController.getName());
                throwable.printStackTrace();
            }
        }
    }

    public List<IController> getControllers() {
        return this.cachedControllers;
    }

    private void registerControllers() {
        if (bad) {
            return;
        }
        this.controllers = new HashMap<String, IController>();
        this.cachedClassControllers = new HashMap<Class<? extends IController>, IController>();
        for (Field field : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Control.class)) continue;
            try {
                field.setAccessible(true);
                IController iController = (IController)field.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
                this.registerController(iController);
                field.set((Object)this, iController);
                this.v("Registered " + iController.getName() + " (" + field.getName() + ")");
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                this.w("Failed to register controller (field " + field.getName() + ")");
                exception.printStackTrace();
            }
        }
        this.cachedControllers = XMap.v(this.controllers);
    }

    public IController getController(Class<? extends IController> clazz) {
        return this.cachedClassControllers.get(clazz);
    }

    private void registerController(IController iController) {
        if (bad) {
            return;
        }
        this.controllers.put(iController.getName(), iController);
        this.cachedClassControllers.put(iController.getClass(), iController);
        this.registerListener(iController);
        try {
            iController.start();
            this.v("Started " + iController.getName());
        }
        catch (Throwable throwable) {
            this.w("Failed to start controller " + iController.getName());
            throwable.printStackTrace();
        }
    }

    private void registerInstance() {
        if (bad) {
            return;
        }
        for (Field field : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Instance.class)) continue;
            try {
                field.setAccessible(true);
                field.set((Object)(Modifier.isStatic(field.getModifiers()) ? null : this), (Object)this);
                this.v("Registered Instance " + field.getName());
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException exception) {
                this.w("Failed to register instance (field " + field.getName() + ")");
                exception.printStackTrace();
            }
        }
    }

    private void unregisterInstance() {
        if (bad) {
            return;
        }
        for (Field field : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Instance.class)) continue;
            try {
                field.setAccessible(true);
                field.set((Object)(Modifier.isStatic(field.getModifiers()) ? null : this), null);
                this.v("Unregistered Instance " + field.getName());
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException exception) {
                this.w("Failed to unregister instance (field " + field.getName() + ")");
                exception.printStackTrace();
            }
        }
    }

    public String getTag() {
        if (bad) {
            return "";
        }
        return this.getTag("");
    }

    public void registerListener(Listener listener) {
        if (bad) {
            return;
        }
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)this);
    }

    public void unregisterListener(Listener listener) {
        if (bad) {
            return;
        }
        HandlerList.unregisterAll((Listener)listener);
    }

    public void unregisterListeners() {
        if (bad) {
            return;
        }
        HandlerList.unregisterAll((Listener)this);
    }

    private void stopControllers() {
        if (bad) {
            return;
        }
        for (IController iController : XMap.v(this.controllers)) {
            try {
                this.unregisterListener(iController);
                iController.stop();
                this.v("Stopped " + iController.getName());
            }
            catch (Throwable throwable) {
                this.w("Failed to stop controller " + iController.getName());
                throwable.printStackTrace();
            }
        }
    }

    public File getDataFile(String ... stringArray) {
        ArrayList arrayList = new ArrayList();
        XList.add(arrayList, stringArray);
        File file = new File(this.getDataFolder(), XList.toString(arrayList, File.separator));
        file.getParentFile().mkdirs();
        return file;
    }

    public File getDataFileList(String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        XList.add(arrayList, stringArray);
        arrayList.add(0, string);
        File file = new File(this.getDataFolder(), XList.toString(arrayList, File.separator));
        file.getParentFile().mkdirs();
        return file;
    }

    public File getDataFolder(String ... stringArray) {
        if (stringArray.length == 0) {
            return super.getDataFolder();
        }
        ArrayList arrayList = new ArrayList();
        XList.add(arrayList, stringArray);
        File file = new File(this.getDataFolder(), XList.toString(arrayList, File.separator));
        file.mkdirs();
        return file;
    }

    public File getDataFolderList(String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        XList.add(arrayList, stringArray);
        arrayList.add(0, string);
        File file = new File(this.getDataFolder(), XList.toString(arrayList, File.separator));
        file.mkdirs();
        return file;
    }

    public abstract void start();

    public abstract void stop();

    public abstract String getTag(String var1);

    static {
        IBootstrap.dasBoot();
        bad = false;
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=997807&resource_id=103790&nonce=1609061583").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

