/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.amulet.io;

import com.volmit.adapt.util.arcane.amulet.io.FileWatcher;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FolderWatcher
extends FileWatcher {
    private Map<File, FolderWatcher> watchers;
    private List<File> changed;
    private List<File> created;
    private List<File> deleted;

    public FolderWatcher(File file) {
        super(file);
    }

    @Override
    protected void readProperties() {
        if (this.watchers == null) {
            this.watchers = new HashMap<File, FolderWatcher>();
            this.changed = new ArrayList<File>();
            this.created = new ArrayList<File>();
            this.deleted = new ArrayList<File>();
        }
        if (this.file.isDirectory()) {
            for (File file : this.file.listFiles()) {
                if (this.watchers.containsKey(file)) continue;
                this.watchers.put(file, new FolderWatcher(file));
            }
            for (File file : XMap.k(this.watchers)) {
                if (file.exists()) continue;
                this.watchers.remove(file);
            }
        } else {
            super.readProperties();
        }
    }

    @Override
    public boolean checkModified() {
        this.changed.clear();
        this.created.clear();
        this.deleted.clear();
        if (this.file.isDirectory()) {
            Map<File, FolderWatcher> map = XMap.copy(this.watchers);
            this.readProperties();
            for (File file : map.keySet()) {
                if (this.watchers.containsKey(file)) continue;
                this.deleted.add(file);
            }
            for (File file : this.watchers.keySet()) {
                if (!map.containsKey(file)) {
                    this.created.add(file);
                    continue;
                }
                FolderWatcher folderWatcher = this.watchers.get(file);
                if (folderWatcher.checkModified()) {
                    this.changed.add(folderWatcher.file);
                }
                this.changed.addAll(folderWatcher.getChanged());
                this.created.addAll(folderWatcher.getCreated());
                this.deleted.addAll(folderWatcher.getDeleted());
            }
            return !this.changed.isEmpty() || !this.created.isEmpty() || !this.deleted.isEmpty();
        }
        return super.checkModified();
    }

    public boolean checkModifiedFast() {
        if (this.watchers == null || this.watchers.isEmpty()) {
            return this.checkModified();
        }
        this.changed.clear();
        this.created.clear();
        this.deleted.clear();
        if (this.file.isDirectory()) {
            for (File file : this.watchers.keySet()) {
                FolderWatcher folderWatcher = this.watchers.get(file);
                if (folderWatcher.checkModifiedFast()) {
                    this.changed.add(folderWatcher.file);
                }
                this.changed.addAll(folderWatcher.getChanged());
                this.created.addAll(folderWatcher.getCreated());
                this.deleted.addAll(folderWatcher.getDeleted());
            }
            return !this.changed.isEmpty() || !this.created.isEmpty() || !this.deleted.isEmpty();
        }
        return super.checkModified();
    }

    public Map<File, FolderWatcher> getWatchers() {
        return this.watchers;
    }

    public List<File> getChanged() {
        return this.changed;
    }

    public List<File> getCreated() {
        return this.created;
    }

    public List<File> getDeleted() {
        return this.deleted;
    }

    public void clear() {
        this.watchers.clear();
        this.changed.clear();
        this.deleted.clear();
        this.created.clear();
    }

    static {
        IBootstrap.dasBoot();
    }
}

