/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse.model;

import com.volmit.adapt.util.arcane.curse.Curse;
import com.volmit.adapt.util.arcane.curse.model.CursedConstructor;
import com.volmit.adapt.util.arcane.curse.model.CursedContext;
import com.volmit.adapt.util.arcane.curse.model.CursedField;
import com.volmit.adapt.util.arcane.curse.model.CursedMethod;
import com.volmit.adapt.util.arcane.curse.model.FuzzyField;
import com.volmit.adapt.util.arcane.curse.model.FuzzyMethod;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import spoon.Launcher;
import spoon.reflect.declaration.CtType;
import sun.misc.Unsafe;

public class CursedComponent {
    private final CursedContext context;

    public CursedComponent type(Class<?> clazz) {
        this.context.type(clazz);
        return this;
    }

    public CursedComponent instance(Object object) {
        this.context.instance(object);
        return this;
    }

    public <A extends Annotation> A annotated(Class<A> clazz) {
        return this.context.type().getDeclaredAnnotation(clazz);
    }

    public Stream<CursedMethod> declaredMethods() {
        return Arrays.stream(this.context.type().getDeclaredMethods()).map(method -> new CursedMethod(this.context(), (Method)method));
    }

    public Stream<CursedMethod> methods() {
        return CursedComponent.getMethods(this.context.type()).map(method -> new CursedMethod(this.context(), (Method)method));
    }

    public CtType<?> model() {
        Launcher launcher = new Launcher();
        File file = Curse.temp("lchr", UUID.randomUUID() + ".java");
        String string = Curse.decompile(this.context.type());
        Curse.write(file, string);
        launcher.addInputResource(file.getAbsolutePath());
        return (CtType)launcher.buildModel().filterChildren(ctType -> ctType.getQualifiedName().equals(this.context.type().getCanonicalName())).first();
    }

    public <T> T instance() {
        return (T)this.context.instance();
    }

    public Class<?> type() {
        return this.context.type();
    }

    public CursedComponent make() {
        try {
            return this.construct(new Object[0]);
        }
        catch (Throwable throwable) {
            return this.forceMake();
        }
    }

    public CursedComponent forceMake() {
        try {
            return Curse.on(this.type()).instance(this.unsafe().allocateInstance(this.type()));
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    private Unsafe unsafe() {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            return (Unsafe)field.get(null);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public CursedComponent construct(Object ... objectArray) {
        List<Constructor> list = CursedComponent.getConstructors(this.context.type()).filter(constructor -> constructor.getParameterCount() == objectArray.length).toList();
        for (Constructor constructor2 : list) {
            try {
                return Curse.on(constructor2.newInstance(objectArray));
            }
            catch (Throwable throwable) {
            }
        }
        throw new RuntimeException("No constructor found for " + this.context.type() + " with args (" + Arrays.deepToString(objectArray) + ")");
    }

    public Stream<CursedField> fields() {
        return CursedComponent.getFields(this.type()).map(field -> new CursedField(this.context(), (Field)field));
    }

    public Stream<CursedField> instanceFields() {
        return this.fields().filter(cursedField -> !Modifier.isStatic(cursedField.getMember().getModifiers()));
    }

    public Stream<CursedField> staticFields() {
        return this.fields().filter(cursedField -> Modifier.isStatic(cursedField.getMember().getModifiers()));
    }

    public boolean hasInstance() {
        return this.instance() != null;
    }

    public Optional<CursedField> fuzzyField(Class<?> clazz) {
        return this.fuzzyField(clazz, !this.hasInstance());
    }

    public Optional<CursedField> fuzzyField(Class<?> clazz, boolean bl) {
        return this.fields().filter(cursedField -> cursedField.isStatic() == bl && cursedField.field().getType().equals(clazz)).findFirst().or(() -> this.fields().filter(cursedField -> cursedField.isStatic() == bl && cursedField.field().getType().isAssignableFrom(clazz)).findFirst());
    }

    public Optional<CursedField> fuzzyField(FuzzyField fuzzyField) {
        return this.fields().filter(cursedField -> fuzzyField.isStaticField() == cursedField.isStatic()).filter(cursedField -> fuzzyField.getType().equals(cursedField.field().getType())).filter(cursedField -> fuzzyField.getPossibleNames() == null || fuzzyField.getPossibleNames().isEmpty() || fuzzyField.getPossibleNames().contains(cursedField.field().getName())).findFirst();
    }

    public Optional<CursedMethod> fuzzyMethod(FuzzyMethod fuzzyMethod) {
        return CursedComponent.getMethods(this.type()).filter(method -> fuzzyMethod.isStaticMethod() == Modifier.isStatic(method.getModifiers())).filter(method -> fuzzyMethod.getReturns().equals(method.getReturnType())).filter(method -> fuzzyMethod.getPossibleNames() == null || !fuzzyMethod.getPossibleNames().isEmpty() || fuzzyMethod.getPossibleNames().contains(method.getName())).filter(method -> {
            if ((fuzzyMethod.getParameters() == null || fuzzyMethod.getParameters().isEmpty()) && method.getParameterCount() == 0) {
                return true;
            }
            if (fuzzyMethod.getParameters() != null && method.getParameterCount() == fuzzyMethod.getParameters().size()) {
                for (int i = 0; i < method.getParameterCount(); ++i) {
                    Class<?> clazz;
                    Class<?> clazz2 = method.getParameterTypes()[i];
                    if (!clazz2.isAssignableFrom(clazz = fuzzyMethod.getParameters().get(i)) && !clazz.isAssignableFrom(clazz2)) continue;
                    return true;
                }
            }
            return false;
        }).map(method -> new CursedMethod(this.context(), (Method)method)).findFirst();
    }

    public <T> T getTyped(Class<?> clazz) {
        return (T)this.fuzzyField(clazz).map(cursedField -> cursedField.get()).or(() -> this.fuzzyMethod(FuzzyMethod.builder().parameters(new ArrayList()).returns(clazz).staticMethod(!this.hasInstance()).build()).map(cursedMethod -> cursedMethod.invoke(new Object[0])));
    }

    public <T> T get(String string) {
        try {
            return this.field(string).get();
        }
        catch (Throwable throwable) {
            try {
                return this.method("get" + CursedComponent.capitalize(string), new Class[0]).invoke(new Object[0]);
            }
            catch (Throwable throwable2) {
                throw new RuntimeException("No such field or getter: " + string + " or get" + CursedComponent.capitalize(string) + "()");
            }
        }
    }

    public CursedComponent set(String string, Object object) {
        try {
            return this.setOrThrow(string, object);
        }
        catch (Throwable throwable) {
            return this;
        }
    }

    public CursedComponent setOrThrow(String string, Object object) {
        try {
            this.field(string).set(object);
            return this;
        }
        catch (Throwable throwable) {
            try {
                this.method("set" + CursedComponent.capitalize(string), object.getClass()).invoke(object);
                return this;
            }
            catch (Throwable throwable2) {
                try {
                    CursedComponent.getMethods(this.context().type()).filter(method -> method.getName().equals("set" + CursedComponent.capitalize(string))).findFirst().ifPresent(method -> {
                        try {
                            method.invoke(this.context().instance(), object);
                        }
                        catch (Throwable throwable) {
                            throw new RuntimeException(throwable);
                        }
                    });
                    return this;
                }
                catch (Throwable throwable3) {
                    throw new RuntimeException("No such field or setter: " + string + " or set" + CursedComponent.capitalize(string) + "(" + object.getClass() + "). Also searched for any setter with any parameter type. If you are trying to set an object through a setter which does not have the same exact parameter type as your value, use set(name, value, type) instead.");
                }
            }
        }
    }

    public CursedComponent set(String string, Object object, Class<?> clazz) {
        try {
            this.field(string).set(object);
            return this;
        }
        catch (Throwable throwable) {
            try {
                this.method("set" + CursedComponent.capitalize(string), clazz).invoke(object);
                return this;
            }
            catch (Throwable throwable2) {
                throw new RuntimeException("No such field or setter: " + string + " or set" + CursedComponent.capitalize(string) + "(" + object.getClass() + ").");
            }
        }
    }

    private static String capitalize(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public CursedField field(Class<?> clazz) {
        return CursedComponent.getFields(this.context().type()).filter(field -> field.getType().equals(clazz)).findFirst().map(field -> this.field(field.getName())).orElseThrow(() -> new RuntimeException("No field of type " + clazz + " in " + this.context.type()));
    }

    public CursedMethod methodReturning(Class<?> clazz) {
        return CursedComponent.getMethods(this.context().type()).filter(method -> method.getReturnType().equals(clazz)).findFirst().map(method -> this.method(method.getName(), method.getParameterTypes())).orElseThrow(() -> new RuntimeException("No method returning type " + clazz + " in " + this.context.type()));
    }

    public CursedMethod methodReturningArgs(Class<?> clazz, Class<?> ... classArray) {
        return CursedComponent.getMethods(this.context().type()).filter(method -> method.getReturnType().equals(clazz)).filter(method -> Arrays.equals(method.getParameterTypes(), classArray)).findFirst().map(method -> this.method(method.getName(), method.getParameterTypes())).orElseThrow(() -> new RuntimeException("No method returning type " + clazz + " with args (" + Arrays.deepToString(classArray) + ") in " + this.context.type()));
    }

    public CursedMethod methodArgs(Class<?> ... classArray) {
        return CursedComponent.getMethods(this.context().type()).filter(method -> Arrays.equals(method.getParameterTypes(), classArray)).findFirst().map(method -> this.method(method.getName(), method.getParameterTypes())).orElseThrow(() -> new RuntimeException("No method with args (" + Arrays.deepToString(classArray) + ") in " + this.context.type()));
    }

    public Optional<CursedField> optionalField(String string) {
        return Optional.ofNullable(CursedComponent.getField(this.context.type(), string)).map(field -> new CursedField(this.context, (Field)field));
    }

    public CursedField field(String string) {
        return this.optionalField(string).get();
    }

    public Optional<CursedMethod> optionalMethod(String string, Class<?> ... classArray) {
        return Optional.ofNullable(CursedComponent.getMethod(this.context.type(), string, classArray)).map(method -> new CursedMethod(this.context, (Method)method));
    }

    public CursedMethod method(String string, Class<?> ... classArray) {
        return this.optionalMethod(string, classArray).get();
    }

    public Optional<CursedConstructor> optionalConstructor(Class<?> ... classArray) {
        return Optional.ofNullable(CursedComponent.getConstructor(this.context.type(), classArray)).map(constructor -> new CursedConstructor(this.context, (Constructor<?>)constructor));
    }

    public CursedConstructor constructor(Class<?> ... classArray) {
        return this.optionalConstructor(classArray).get();
    }

    private static Field getField(Class<?> clazz, String string) {
        try {
            return clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException | SecurityException exception) {
            Class<?> clazz2 = clazz.getSuperclass();
            if (clazz2 == null) {
                return null;
            }
            return CursedComponent.getField(clazz2, string);
        }
    }

    private static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            Class<?> clazz2 = clazz.getSuperclass();
            if (clazz2 == null) {
                return null;
            }
            return CursedComponent.getMethod(clazz2, string, classArray);
        }
    }

    private static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... classArray) {
        try {
            return clazz.getDeclaredConstructor(classArray);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            Class<?> clazz2 = clazz.getSuperclass();
            if (clazz2 == null) {
                return null;
            }
            return CursedComponent.getConstructor(clazz2, classArray);
        }
    }

    private static Stream<Field> getFields(Class<?> clazz) {
        Stream.Builder<Field> builder = Stream.builder();
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                builder.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return builder.build();
    }

    private static Stream<Method> getMethods(Class<?> clazz) {
        Stream.Builder<Method> builder = Stream.builder();
        while (clazz != Object.class) {
            for (Method method : clazz.getDeclaredMethods()) {
                builder.add(method);
            }
            clazz = clazz.getSuperclass();
        }
        return builder.build();
    }

    private static Stream<Constructor<?>> getConstructors(Class<?> clazz) {
        Stream.Builder<Constructor<?>> builder = Stream.builder();
        while (clazz != Object.class) {
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                builder.add(constructor);
            }
            clazz = clazz.getSuperclass();
        }
        return builder.build();
    }

    public CursedContext context() {
        return this.context;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CursedComponent)) {
            return false;
        }
        CursedComponent cursedComponent = (CursedComponent)object;
        if (!cursedComponent.canEqual(this)) {
            return false;
        }
        CursedContext cursedContext = this.context();
        CursedContext cursedContext2 = cursedComponent.context();
        return !(cursedContext == null ? cursedContext2 != null : !((Object)cursedContext).equals(cursedContext2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof CursedComponent;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        CursedContext cursedContext = this.context();
        n2 = n2 * 59 + (cursedContext == null ? 43 : ((Object)cursedContext).hashCode());
        return n2;
    }

    public String toString() {
        return "CursedComponent(context=" + this.context() + ")";
    }

    public CursedComponent(CursedContext cursedContext) {
        this.context = cursedContext;
    }
}

