/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse.model;

import com.volmit.adapt.util.arcane.curse.Curse;
import com.volmit.adapt.util.arcane.curse.model.CursedContext;
import com.volmit.adapt.util.arcane.curse.model.CursedExecutable;
import java.lang.reflect.Method;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtMethod;

public class CursedMethod
extends CursedExecutable {
    private final Method method;

    public CursedMethod(CursedContext cursedContext, Method method) {
        super(cursedContext, method);
        this.method = method;
    }

    public CtMethod<?> model() {
        return (CtMethod)Curse.on(this.method.getDeclaringClass()).model().filterChildren(ctMethod -> ctMethod.getSimpleName().equals(this.method.getName()) && ctMethod.getParameters().stream().map(ctParameter -> ctParameter.getType().getActualClass().getCanonicalName()).collect(Collectors.joining(", ")).equals(Stream.of(this.method.getParameterTypes()).map(Class::getCanonicalName).collect(Collectors.joining(", ")))).first();
    }

    public SourcePosition getSourcePosition() {
        return this.model().getPosition();
    }

    public <T> T invoke(Object ... objectArray) {
        try {
            this.method.setAccessible(true);
            return (T)this.method.invoke(this.context.instance(), objectArray);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public Method method() {
        return this.method;
    }
}

