/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse.util.poet;

import com.volmit.adapt.util.arcane.curse.util.poet.Util;

final class LineWrapper {
    private final RecordingAppendable out;
    private final String indent;
    private final int columnLimit;
    private boolean closed;
    private final StringBuilder buffer = new StringBuilder();
    private int column = 0;
    private int indentLevel = -1;
    private FlushType nextFlush;

    LineWrapper(Appendable appendable, String string, int n) {
        Util.checkNotNull(appendable, "out == null", new Object[0]);
        this.out = new RecordingAppendable(appendable);
        this.indent = string;
        this.columnLimit = n;
    }

    char lastChar() {
        return this.out.lastChar;
    }

    void append(String string) {
        int n;
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.nextFlush != null) {
            n = string.indexOf(10);
            if (n == -1 && this.column + string.length() <= this.columnLimit) {
                this.buffer.append(string);
                this.column += string.length();
                return;
            }
            boolean bl = n == -1 || this.column + n > this.columnLimit;
            this.flush(bl ? FlushType.WRAP : this.nextFlush);
        }
        this.out.append(string);
        n = string.lastIndexOf(10);
        this.column = n != -1 ? string.length() - n - 1 : this.column + string.length();
    }

    void wrappingSpace(int n) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.nextFlush != null) {
            this.flush(this.nextFlush);
        }
        ++this.column;
        this.nextFlush = FlushType.SPACE;
        this.indentLevel = n;
    }

    void zeroWidthSpace(int n) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.column == 0) {
            return;
        }
        if (this.nextFlush != null) {
            this.flush(this.nextFlush);
        }
        this.nextFlush = FlushType.EMPTY;
        this.indentLevel = n;
    }

    void close() {
        if (this.nextFlush != null) {
            this.flush(this.nextFlush);
        }
        this.closed = true;
    }

    private void flush(FlushType flushType) {
        switch (flushType) {
            case WRAP: {
                this.out.append('\n');
                for (int i = 0; i < this.indentLevel; ++i) {
                    this.out.append(this.indent);
                }
                this.column = this.indentLevel * this.indent.length();
                this.column += this.buffer.length();
                break;
            }
            case SPACE: {
                this.out.append(' ');
                break;
            }
            case EMPTY: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown FlushType: " + flushType);
            }
        }
        this.out.append(this.buffer);
        this.buffer.delete(0, this.buffer.length());
        this.indentLevel = -1;
        this.nextFlush = null;
    }

    static final class RecordingAppendable
    implements Appendable {
        private final Appendable delegate;
        char lastChar = '\u0000';

        RecordingAppendable(Appendable appendable) {
            this.delegate = appendable;
        }

        @Override
        public Appendable append(CharSequence charSequence) {
            int n = charSequence.length();
            if (n != 0) {
                this.lastChar = charSequence.charAt(n - 1);
            }
            return this.delegate.append(charSequence);
        }

        @Override
        public Appendable append(CharSequence charSequence, int n, int n2) {
            CharSequence charSequence2 = charSequence.subSequence(n, n2);
            return this.append(charSequence2);
        }

        @Override
        public Appendable append(char c) {
            this.lastChar = c;
            return this.delegate.append(c);
        }
    }

    private static enum FlushType {
        WRAP,
        SPACE,
        EMPTY;

    }
}

