/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse.util.poet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;

final class Util {
    private Util() {
    }

    static <K, V> Map<K, List<V>> immutableMultimap(Map<K, List<V>> map) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry<K, List<V>> entry : map.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            linkedHashMap.put(entry.getKey(), Util.immutableList((Collection)entry.getValue()));
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    static <K, V> Map<K, V> immutableMap(Map<K, V> map) {
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
    }

    static void checkArgument(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
    }

    static <T> T checkNotNull(T t, String string, Object ... objectArray) {
        if (t == null) {
            throw new NullPointerException(String.format(string, objectArray));
        }
        return t;
    }

    static void checkState(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            throw new IllegalStateException(String.format(string, objectArray));
        }
    }

    static <T> List<T> immutableList(Collection<T> collection) {
        return Collections.unmodifiableList(new ArrayList<T>(collection));
    }

    static <T> Set<T> immutableSet(Collection<T> collection) {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(collection));
    }

    static <T> Set<T> union(Set<T> set, Set<T> set2) {
        LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>();
        linkedHashSet.addAll(set);
        linkedHashSet.addAll(set2);
        return linkedHashSet;
    }

    static void requireExactlyOneOf(Set<Modifier> set, Modifier ... modifierArray) {
        int n = 0;
        for (Modifier modifier : modifierArray) {
            if (!set.contains((Object)modifier)) continue;
            ++n;
        }
        Util.checkArgument(n == 1, "modifiers %s must contain one of %s", set, Arrays.toString((Object[])modifierArray));
    }

    static String characterLiteralWithoutSingleQuotes(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\"': {
                return "\"";
            }
            case '\'': {
                return "\\'";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return Character.isISOControl(c) ? String.format("\\u%04x", c) : Character.toString(c);
    }

    static String stringLiteralWithDoubleQuotes(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        stringBuilder.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                stringBuilder.append("'");
                continue;
            }
            if (c == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            stringBuilder.append(Util.characterLiteralWithoutSingleQuotes(c));
            if (c != '\n' || i + 1 >= string.length()) continue;
            stringBuilder.append("\"\n").append(string2).append(string2).append("+ \"");
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }
}

