/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.storage;

import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.StorageHunk;
import com.volmit.adapt.util.arcane.spatial.util.CompressedNumbers;
import java.util.Arrays;

public class ArrayHunk<T>
extends StorageHunk<T>
implements Hunk<T> {
    private final T[] data;

    public ArrayHunk(int n, int n2, int n3) {
        super(n, n2, n3);
        this.data = new Object[n * n2 * n3];
    }

    @Override
    public void setRaw(int n, int n2, int n3, T t) {
        this.data[this.index((int)n, (int)n2, (int)n3)] = t;
    }

    @Override
    public T getRaw(int n, int n2, int n3) {
        return this.data[this.index(n, n2, n3)];
    }

    private int index(int n, int n2, int n3) {
        return CompressedNumbers.index3Dto1D(n, n2, n3, this.getWidth(), this.getHeight());
    }

    @Override
    public void fill(T t) {
        Arrays.fill(this.data, t);
    }

    public T[] getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "ArrayHunk(data=" + Arrays.deepToString(this.getData()) + ")";
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ArrayHunk)) {
            return false;
        }
        ArrayHunk arrayHunk = (ArrayHunk)object;
        if (!arrayHunk.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getData(), arrayHunk.getData());
    }

    @Override
    protected boolean canEqual(Object object) {
        return object instanceof ArrayHunk;
    }

    @Override
    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + Arrays.deepHashCode(this.getData());
        return n2;
    }
}

