/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.storage;

import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.StorageHunk;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class AtomicIntegerHunk
extends StorageHunk<Integer>
implements Hunk<Integer> {
    private final AtomicIntegerArray data;

    public AtomicIntegerHunk(int n, int n2, int n3) {
        super(n, n2, n3);
        this.data = new AtomicIntegerArray(n * n2 * n3);
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public void setRaw(int n, int n2, int n3, Integer n4) {
        this.data.set(this.index(n, n2, n3), n4);
    }

    @Override
    public Integer getRaw(int n, int n2, int n3) {
        return this.data.get(this.index(n, n2, n3));
    }

    private int index(int n, int n2, int n3) {
        return n3 * this.getWidth() * this.getHeight() + n2 * this.getWidth() + n;
    }

    public AtomicIntegerArray getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "AtomicIntegerHunk(data=" + this.getData() + ")";
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AtomicIntegerHunk)) {
            return false;
        }
        AtomicIntegerHunk atomicIntegerHunk = (AtomicIntegerHunk)object;
        if (!atomicIntegerHunk.canEqual(this)) {
            return false;
        }
        AtomicIntegerArray atomicIntegerArray = this.getData();
        AtomicIntegerArray atomicIntegerArray2 = atomicIntegerHunk.getData();
        return !(atomicIntegerArray == null ? atomicIntegerArray2 != null : !atomicIntegerArray.equals(atomicIntegerArray2));
    }

    @Override
    protected boolean canEqual(Object object) {
        return object instanceof AtomicIntegerHunk;
    }

    @Override
    public int hashCode() {
        int n = 59;
        int n2 = 1;
        AtomicIntegerArray atomicIntegerArray = this.getData();
        n2 = n2 * 59 + (atomicIntegerArray == null ? 43 : atomicIntegerArray.hashCode());
        return n2;
    }
}

