/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.storage;

import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.StorageHunk;
import java.util.concurrent.atomic.AtomicLongArray;

public class AtomicLongHunk
extends StorageHunk<Long>
implements Hunk<Long> {
    private final AtomicLongArray data;

    public AtomicLongHunk(int n, int n2, int n3) {
        super(n, n2, n3);
        this.data = new AtomicLongArray(n * n2 * n3);
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public void setRaw(int n, int n2, int n3, Long l) {
        this.data.set(this.index(n, n2, n3), l);
    }

    @Override
    public Long getRaw(int n, int n2, int n3) {
        return this.data.get(this.index(n, n2, n3));
    }

    private int index(int n, int n2, int n3) {
        return n3 * this.getWidth() * this.getHeight() + n2 * this.getWidth() + n;
    }

    public AtomicLongArray getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "AtomicLongHunk(data=" + this.getData() + ")";
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AtomicLongHunk)) {
            return false;
        }
        AtomicLongHunk atomicLongHunk = (AtomicLongHunk)object;
        if (!atomicLongHunk.canEqual(this)) {
            return false;
        }
        AtomicLongArray atomicLongArray = this.getData();
        AtomicLongArray atomicLongArray2 = atomicLongHunk.getData();
        return !(atomicLongArray == null ? atomicLongArray2 != null : !atomicLongArray.equals(atomicLongArray2));
    }

    @Override
    protected boolean canEqual(Object object) {
        return object instanceof AtomicLongHunk;
    }

    @Override
    public int hashCode() {
        int n = 59;
        int n2 = 1;
        AtomicLongArray atomicLongArray = this.getData();
        n2 = n2 * 59 + (atomicLongArray == null ? 43 : atomicLongArray.hashCode());
        return n2;
    }
}

