/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.storage;

import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.StorageHunk;
import com.volmit.adapt.util.arcane.spatial.util.Consume;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MappedHunk<T>
extends StorageHunk<T>
implements Hunk<T> {
    private final Map<Integer, T> data = new ConcurrentHashMap<Integer, T>();

    public MappedHunk(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    @Override
    public int getEntryCount() {
        return this.data.size();
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public void setRaw(int n, int n2, int n3, T t) {
        if (t == null) {
            this.data.remove(this.index(n, n2, n3));
            return;
        }
        this.data.put(this.index(n, n2, n3), t);
    }

    private Integer index(int n, int n2, int n3) {
        return n3 * this.getWidth() * this.getHeight() + n2 * this.getWidth() + n;
    }

    @Override
    public synchronized Hunk<T> iterateSync(Consume.Four<Integer, Integer, Integer, T> four) {
        for (Map.Entry<Integer, T> entry : this.data.entrySet()) {
            int n = entry.getKey();
            int n2 = n / (this.getWidth() * this.getHeight());
            four.accept((n -= n2 * this.getWidth() * this.getHeight()) % this.getWidth(), n / this.getWidth(), n2, entry.getValue());
        }
        return this;
    }

    @Override
    public synchronized Hunk<T> iterateSyncIO(Consume.FourIO<Integer, Integer, Integer, T> fourIO) {
        for (Map.Entry<Integer, T> entry : this.data.entrySet()) {
            int n = entry.getKey();
            int n2 = n / (this.getWidth() * this.getHeight());
            fourIO.accept((n -= n2 * this.getWidth() * this.getHeight()) % this.getWidth(), n / this.getWidth(), n2, entry.getValue());
        }
        return this;
    }

    @Override
    public void empty(T t) {
        this.data.clear();
    }

    @Override
    public T getRaw(int n, int n2, int n3) {
        return this.data.get(this.index(n, n2, n3));
    }

    public Map<Integer, T> getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "MappedHunk(data=" + this.getData() + ")";
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MappedHunk)) {
            return false;
        }
        MappedHunk mappedHunk = (MappedHunk)object;
        if (!mappedHunk.canEqual(this)) {
            return false;
        }
        Map<Integer, T> map = this.getData();
        Map<Integer, T> map2 = mappedHunk.getData();
        return !(map == null ? map2 != null : !((Object)map).equals(map2));
    }

    @Override
    protected boolean canEqual(Object object) {
        return object instanceof MappedHunk;
    }

    @Override
    public int hashCode() {
        int n = 59;
        int n2 = 1;
        Map<Integer, T> map = this.getData();
        n2 = n2 * 59 + (map == null ? 43 : ((Object)map).hashCode());
        return n2;
    }
}

