/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.storage;

import com.volmit.adapt.util.arcane.spatial.container.DataContainer;
import com.volmit.adapt.util.arcane.spatial.container.NodeWritable;
import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.PaletteHunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.StorageHunk;
import com.volmit.adapt.util.arcane.spatial.util.Consume;
import java.util.function.Supplier;

public abstract class PaletteOrHunk<T>
extends StorageHunk<T>
implements Hunk<T>,
NodeWritable<T> {
    private final Hunk<T> hunk;

    public PaletteOrHunk(int n, int n2, int n3, boolean bl, Supplier<Hunk<T>> supplier) {
        super(n, n2, n3);
        this.hunk = bl && n * n2 * n3 <= 4096 ? new PaletteHunk(n, n2, n3, this) : supplier.get();
    }

    public DataContainer<T> palette() {
        return this.isPalette() ? ((PaletteHunk)this.hunk).getData() : null;
    }

    public void setPalette(DataContainer<T> dataContainer) {
        if (this.isPalette()) {
            ((PaletteHunk)this.hunk).setPalette(dataContainer);
        }
    }

    public boolean isPalette() {
        return this.hunk instanceof PaletteHunk;
    }

    @Override
    public void setRaw(int n, int n2, int n3, T t) {
        this.hunk.setRaw(n, n2, n3, t);
    }

    @Override
    public T getRaw(int n, int n2, int n3) {
        return this.hunk.getRaw(n, n2, n3);
    }

    @Override
    public int getEntryCount() {
        return this.hunk.getEntryCount();
    }

    @Override
    public boolean isMapped() {
        return this.hunk.isMapped();
    }

    @Override
    public boolean isEmpty() {
        return this.hunk.isMapped();
    }

    @Override
    public synchronized Hunk<T> iterateSync(Consume.Four<Integer, Integer, Integer, T> four) {
        this.hunk.iterateSync(four);
        return this;
    }

    @Override
    public synchronized Hunk<T> iterateSyncIO(Consume.FourIO<Integer, Integer, Integer, T> fourIO) {
        this.hunk.iterateSyncIO(fourIO);
        return this;
    }

    @Override
    public void empty(T t) {
        this.hunk.empty(t);
    }
}

