/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.mantle;

import com.volmit.adapt.util.arcane.spatial.matter.Matter;
import com.volmit.adapt.util.arcane.spatial.matter.MatterSlice;
import com.volmit.adapt.util.arcane.spatial.matter.SpatialMatter;
import com.volmit.adapt.util.arcane.spatial.util.Consume;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class MantleChunk {
    private final int x;
    private final int z;
    private final AtomicReferenceArray<Matter> sections;

    public MantleChunk(int n, int n2, int n3) {
        this.sections = new AtomicReferenceArray(n);
        this.x = n2;
        this.z = n3;
    }

    public MantleChunk(int n, DataInputStream dataInputStream) {
        this(n, dataInputStream.readByte(), dataInputStream.readByte());
        int n2 = dataInputStream.readByte();
        for (int i = 0; i < n2; ++i) {
            if (!dataInputStream.readBoolean()) continue;
            this.sections.set(i, Matter.readDin(dataInputStream));
        }
    }

    public boolean exists(int n) {
        return this.get(n) != null;
    }

    public Matter get(int n) {
        return this.sections.get(n);
    }

    public void clear() {
        for (int i = 0; i < this.sections.length(); ++i) {
            this.delete(i);
        }
    }

    public void delete(int n) {
        this.sections.set(n, null);
    }

    public Matter getOrCreate(int n) {
        Matter matter = this.get(n);
        if (matter == null) {
            matter = new SpatialMatter(16, 16, 16);
            this.sections.set(n, matter);
        }
        return matter;
    }

    public void write(DataOutputStream dataOutputStream) {
        dataOutputStream.writeByte(this.x);
        dataOutputStream.writeByte(this.z);
        dataOutputStream.writeByte(this.sections.length());
        for (int i = 0; i < this.sections.length(); ++i) {
            this.trimSlice(i);
            if (this.exists(i)) {
                dataOutputStream.writeBoolean(true);
                Matter matter = this.get(i);
                matter.writeDos(dataOutputStream);
                continue;
            }
            dataOutputStream.writeBoolean(false);
        }
    }

    private void trimSlice(int n) {
        if (this.exists(n)) {
            Matter matter = this.get(n);
            if (matter.getSliceMap().isEmpty()) {
                this.sections.set(n, null);
            } else {
                matter.trimSlices();
                if (matter.getSliceMap().isEmpty()) {
                    this.sections.set(n, null);
                }
            }
        }
    }

    public <T> void iterate(Class<T> clazz, Consume.Four<Integer, Integer, Integer, T> four) {
        for (int i = 0; i < this.sections.length(); ++i) {
            MatterSlice<Object> matterSlice;
            int n = i << 4;
            Matter matter = this.get(i);
            if (matter == null || (matterSlice = matter.getSlice(clazz)) == null) continue;
            matterSlice.iterateSync((n2, n3, n4, object) -> four.accept((Integer)n2, n3 + n, (Integer)n4, (Object)object));
        }
    }

    public void deleteSlices(Class<?> clazz) {
        for (int i = 0; i < this.sections.length(); ++i) {
            Matter matter = this.sections.get(i);
            if (matter == null || !matter.hasSlice(clazz)) continue;
            matter.deleteSlice(clazz);
        }
    }

    public void trimSlices() {
        for (int i = 0; i < this.sections.length(); ++i) {
            if (!this.exists(i)) continue;
            this.trimSlice(i);
        }
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }
}

