/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.command;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.command.SoundFeedback;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Feedback {
    private List<SoundFeedback> sounds;
    private List<TextComponent> messages;

    public void send(CommandSender commandSender) {
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            for (SoundFeedback object : this.sounds) {
                object.play(player);
            }
        }
        for (TextComponent textComponent : this.messages) {
            String string = C.GRAY + "[" + C.DARK_RED + "Adapt" + C.GRAY + "]:";
            Adapt.audiences.sender(commandSender).sendMessage((Component)textComponent.content(string + " " + textComponent.content()));
        }
    }

    Feedback(List<SoundFeedback> list, List<TextComponent> list2) {
        this.sounds = list;
        this.messages = list2;
    }

    public static FeedbackBuilder builder() {
        return new FeedbackBuilder();
    }

    public List<SoundFeedback> sounds() {
        return this.sounds;
    }

    public List<TextComponent> messages() {
        return this.messages;
    }

    public Feedback sounds(List<SoundFeedback> list) {
        this.sounds = list;
        return this;
    }

    public Feedback messages(List<TextComponent> list) {
        this.messages = list;
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Feedback)) {
            return false;
        }
        Feedback feedback = (Feedback)object;
        if (!feedback.canEqual(this)) {
            return false;
        }
        List<SoundFeedback> list = this.sounds();
        List<SoundFeedback> list2 = feedback.sounds();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        List<TextComponent> list3 = this.messages();
        List<TextComponent> list4 = feedback.messages();
        return !(list3 == null ? list4 != null : !((Object)list3).equals(list4));
    }

    protected boolean canEqual(Object object) {
        return object instanceof Feedback;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        List<SoundFeedback> list = this.sounds();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        List<TextComponent> list2 = this.messages();
        n2 = n2 * 59 + (list2 == null ? 43 : ((Object)list2).hashCode());
        return n2;
    }

    public String toString() {
        return "Feedback(sounds=" + this.sounds() + ", messages=" + this.messages() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class FeedbackBuilder {
        private ArrayList<SoundFeedback> sounds;
        private ArrayList<TextComponent> messages;

        FeedbackBuilder() {
        }

        public FeedbackBuilder sound(SoundFeedback soundFeedback) {
            if (this.sounds == null) {
                this.sounds = new ArrayList();
            }
            this.sounds.add(soundFeedback);
            return this;
        }

        public FeedbackBuilder sounds(Collection<? extends SoundFeedback> collection) {
            if (collection == null) {
                throw new NullPointerException("sounds cannot be null");
            }
            if (this.sounds == null) {
                this.sounds = new ArrayList();
            }
            this.sounds.addAll(collection);
            return this;
        }

        public FeedbackBuilder clearSounds() {
            if (this.sounds != null) {
                this.sounds.clear();
            }
            return this;
        }

        public FeedbackBuilder message(TextComponent textComponent) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.add(textComponent);
            return this;
        }

        public FeedbackBuilder messages(Collection<? extends TextComponent> collection) {
            if (collection == null) {
                throw new NullPointerException("messages cannot be null");
            }
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.addAll(collection);
            return this;
        }

        public FeedbackBuilder clearMessages() {
            if (this.messages != null) {
                this.messages.clear();
            }
            return this;
        }

        public Feedback build() {
            return new Feedback(switch (this.sounds == null ? 0 : this.sounds.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.sounds.get(0));
                default -> Collections.unmodifiableList(new ArrayList<SoundFeedback>(this.sounds));
            }, switch (this.messages == null ? 0 : this.messages.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.messages.get(0));
                default -> Collections.unmodifiableList(new ArrayList<TextComponent>(this.messages));
            });
        }

        public String toString() {
            return "Feedback.FeedbackBuilder(sounds=" + this.sounds + ", messages=" + this.messages + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

