/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.manifold.rt.api.util;

import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class ManClassUtil {
    public static String getNameNoPackage(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46) + 1;
        int n2 = string.lastIndexOf(36) + 1;
        int n3 = Math.max(n, n2);
        return string.substring(n3);
    }

    public static String getPackage(String string) {
        if (string == null || !string.contains(".")) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String getFileExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n);
        }
        return null;
    }

    public static String getFileExtension(File file) {
        String string = file.getName();
        return ManClassUtil.getFileExtension(string);
    }

    public static String getShortClassName(Class clazz) {
        if (clazz == null) {
            return "";
        }
        return ManClassUtil.getShortClassName(clazz.getName());
    }

    public static String getShortClassName(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() == 0) {
            return "";
        }
        int n = string.lastIndexOf(".");
        int n2 = string.indexOf("$", n == -1 ? 0 : n + 1);
        String string2 = string.substring(n + 1);
        if (n2 != -1) {
            string2 = string2.replace("$", ".");
        }
        return string2;
    }

    public static Set<Class> getAllInterfaces(Class clazz) {
        return ManClassUtil.getAllInterfacesImpl(clazz, new HashSet<Class>());
    }

    private static Set<Class> getAllInterfacesImpl(Class clazz, HashSet<Class> hashSet) {
        if (clazz == null || hashSet.contains(clazz)) {
            return hashSet;
        }
        if (clazz.isInterface()) {
            hashSet.add(clazz);
        }
        ManClassUtil.getAllInterfacesImpl(clazz.getSuperclass(), hashSet);
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            ManClassUtil.getAllInterfacesImpl(clazz2, hashSet);
        }
        return hashSet;
    }

    public static boolean isJavaIdentifier(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Class<?> box(Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        throw new IllegalStateException();
    }
}

