/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.manifold.util.concurrent;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentHashSet<K>
implements Set<K> {
    private final ConcurrentMap<K, Boolean> _map;

    public ConcurrentHashSet() {
        this._map = new ConcurrentHashMap<K, Boolean>();
    }

    public ConcurrentHashSet(int n) {
        this._map = new ConcurrentHashMap<K, Boolean>(n);
    }

    public ConcurrentHashSet(Set<K> set) {
        this._map = new ConcurrentHashMap<K, Boolean>(set.size());
        for (K k : set) {
            this._map.put(k, Boolean.TRUE);
        }
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this._map.containsKey(object);
    }

    @Override
    public Iterator<K> iterator() {
        return this._map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this._map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this._map.keySet().toArray(TArray);
    }

    @Override
    public boolean add(K k) {
        return this._map.putIfAbsent(k, Boolean.TRUE) == null;
    }

    @Override
    public boolean remove(Object object) {
        return this._map.keySet().remove(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this._map.keySet().containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends K> collection) {
        boolean bl = false;
        for (K k : collection) {
            bl |= this.add(k);
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this._map.keySet().retainAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this._map.keySet().removeAll(collection);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public String toString() {
        return this._map.keySet().toString();
    }
}

