/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.NormalizedParameters;
import org.slf4j.helpers.Util;

public final class MessageFormatter {
    static final char DELIM_START = '{';
    static final char DELIM_STOP = '}';
    static final String DELIM_STR = "{}";
    private static final char a = '\\';

    public static final FormattingTuple format(String string, Object object) {
        return MessageFormatter.arrayFormat(string, new Object[]{object});
    }

    public static final FormattingTuple format(String string, Object object, Object object2) {
        return MessageFormatter.arrayFormat(string, new Object[]{object, object2});
    }

    public static final FormattingTuple arrayFormat(String string, Object[] objectArray) {
        Throwable throwable = MessageFormatter.getThrowableCandidate(objectArray);
        Object[] objectArray2 = objectArray;
        if (throwable != null) {
            objectArray2 = MessageFormatter.trimmedCopy(objectArray);
        }
        return MessageFormatter.arrayFormat(string, objectArray2, throwable);
    }

    public static final String basicArrayFormat(String object, Object[] objectArray) {
        object = MessageFormatter.arrayFormat((String)object, objectArray, null);
        return ((FormattingTuple)object).getMessage();
    }

    public static String basicArrayFormat(NormalizedParameters normalizedParameters) {
        return MessageFormatter.basicArrayFormat(normalizedParameters.getMessage(), normalizedParameters.getArguments());
    }

    public static final FormattingTuple arrayFormat(String string, Object[] objectArray, Throwable throwable) {
        if (string == null) {
            return new FormattingTuple(null, objectArray, throwable);
        }
        if (objectArray == null) {
            return new FormattingTuple(string);
        }
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder(string.length() + 50);
        for (int i = 0; i < objectArray.length; ++i) {
            char c;
            int n2 = string.indexOf(DELIM_STR, n);
            if (n2 == -1) {
                if (n == 0) {
                    return new FormattingTuple(string, objectArray, throwable);
                }
                stringBuilder.append(string, n, string.length());
                return new FormattingTuple(stringBuilder.toString(), objectArray, throwable);
            }
            int n3 = n2;
            String string2 = string;
            if (n3 != 0 && (c = string2.charAt(n3 - 1)) == '\\') {
                n3 = n2;
                String string3 = string;
                if (!(n3 >= 2 && string3.charAt(n3 - 2) == '\\')) {
                    --i;
                    stringBuilder.append(string, n, n2 - 1);
                    stringBuilder.append('{');
                    n = n2 + 1;
                    continue;
                }
                stringBuilder.append(string, n, n2 - 1);
                MessageFormatter.a(stringBuilder, objectArray[i], new HashMap<Object[], Object>());
                n = n2 + 2;
                continue;
            }
            stringBuilder.append(string, n, n2);
            MessageFormatter.a(stringBuilder, objectArray[i], new HashMap<Object[], Object>());
            n = n2 + 2;
        }
        stringBuilder.append(string, n, string.length());
        return new FormattingTuple(stringBuilder.toString(), objectArray, throwable);
    }

    private static boolean a(String string, int n) {
        if (n == 0) {
            return false;
        }
        char c = string.charAt(n - 1);
        return c == '\\';
    }

    private static boolean b(String string, int n) {
        return n >= 2 && string.charAt(n - 2) == '\\';
    }

    private static void a(StringBuilder stringBuilder, Object object, Map<Object[], Object> map) {
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        if (!object.getClass().isArray()) {
            MessageFormatter.a(stringBuilder, object);
            return;
        }
        if (object instanceof boolean[]) {
            MessageFormatter.a(stringBuilder, (boolean[])object);
            return;
        }
        if (object instanceof byte[]) {
            MessageFormatter.a(stringBuilder, (byte[])object);
            return;
        }
        if (object instanceof char[]) {
            MessageFormatter.a(stringBuilder, (char[])object);
            return;
        }
        if (object instanceof short[]) {
            MessageFormatter.a(stringBuilder, (short[])object);
            return;
        }
        if (object instanceof int[]) {
            MessageFormatter.a(stringBuilder, (int[])object);
            return;
        }
        if (object instanceof long[]) {
            MessageFormatter.a(stringBuilder, (long[])object);
            return;
        }
        if (object instanceof float[]) {
            MessageFormatter.a(stringBuilder, (float[])object);
            return;
        }
        if (object instanceof double[]) {
            MessageFormatter.a(stringBuilder, (double[])object);
            return;
        }
        MessageFormatter.a(stringBuilder, (Object[])object, map);
    }

    private static void a(StringBuilder stringBuilder, Object object) {
        try {
            String string = object.toString();
            stringBuilder.append(string);
            return;
        }
        catch (Throwable throwable) {
            Util.report("SLF4J: Failed toString() invocation on an object of type [" + object.getClass().getName() + "]", throwable);
            stringBuilder.append("[FAILED toString()]");
            return;
        }
    }

    private static void a(StringBuilder stringBuilder, Object[] objectArray, Map<Object[], Object> map) {
        stringBuilder.append('[');
        if (!map.containsKey(objectArray)) {
            map.put(objectArray, null);
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                MessageFormatter.a(stringBuilder, objectArray[i], map);
                if (i == n - 1) continue;
                stringBuilder.append(", ");
            }
            map.remove(objectArray);
        } else {
            stringBuilder.append("...");
        }
        stringBuilder.append(']');
    }

    private static void a(StringBuilder stringBuilder, boolean[] blArray) {
        stringBuilder.append('[');
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(blArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void a(StringBuilder stringBuilder, byte[] byArray) {
        stringBuilder.append('[');
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(byArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void a(StringBuilder stringBuilder, char[] cArray) {
        stringBuilder.append('[');
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(cArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void a(StringBuilder stringBuilder, short[] sArray) {
        stringBuilder.append('[');
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(sArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void a(StringBuilder stringBuilder, int[] nArray) {
        stringBuilder.append('[');
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(nArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void a(StringBuilder stringBuilder, long[] lArray) {
        stringBuilder.append('[');
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(lArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void a(StringBuilder stringBuilder, float[] fArray) {
        stringBuilder.append('[');
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(fArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void a(StringBuilder stringBuilder, double[] dArray) {
        stringBuilder.append('[');
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(dArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    public static Throwable getThrowableCandidate(Object[] objectArray) {
        return NormalizedParameters.getThrowableCandidate(objectArray);
    }

    public static Object[] trimmedCopy(Object[] objectArray) {
        return NormalizedParameters.trimmedCopy(objectArray);
    }
}

