/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.chest;

import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import us.lynuxcraft.deadsilenceiv.advancedchests.AdvancedChestsPlugin;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.BaseChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.NormalPage;

public class NormalChest
extends BaseChest<ItemStack, NormalPage> {
    NormalChest(int n, String string, String string2) {
        super(n, string, AdvancedChestsPlugin.getInstance().getType("NORMAL"), string2);
    }

    protected NormalPage newPage(int n, ItemStack[] itemStackArray) {
        return new NormalPage(n, itemStackArray, (BaseChest<?, ?>)this);
    }

    public NormalPage[] newPageArray(int n) {
        return new NormalPage[n];
    }

    public ItemStack[] newContentArray(int n) {
        return new ItemStack[n];
    }

    @Override
    public void setContent(List<ItemStack> list) {
        if (list.size() == this.getSize().intValue()) {
            int n = 0;
            for (int i = 0; i < this.getPages().size(); ++i) {
                NormalPage normalPage = (NormalPage)this.getPageById(i);
                for (int j = 0; j <= normalPage.getBukkitInventory().getContents().length - 10; ++j) {
                    normalPage.getBukkitInventory().setItem(j, list.get(n));
                    ++n;
                }
            }
        }
    }

    @Override
    public int getSlotsUsed() {
        int n = 0;
        for (ItemStack[] itemStackArray : this.getPages().values()) {
            for (ItemStack itemStack : itemStackArray.getItems()) {
                if (itemStack == null) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    protected boolean handleItemDropping(Block block, @Nullable Player object) {
        super.handleItemDropping(block, (Player)object);
        if (this.config.getOnBreakDropContent()) {
            for (NormalPage normalPage : this.getPages().values()) {
                for (int i = 0; i <= normalPage.getBukkitInventory().getSize() - 10; ++i) {
                    if (normalPage.getBukkitInventory().getItem(i) == null) continue;
                    block.getWorld().dropItem(block.getLocation(), normalPage.getBukkitInventory().getItem(i));
                }
            }
        }
        return true;
    }
}

