/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.buttons;

import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.BaseChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.ChestInventory;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.ShareableChestButton;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.actions.Compressing;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.FormatUtils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.ItemPlaceHolder;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.InteractiveInventory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.items.BaseShareableButtonItem;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.items.ShareableButtonItem;

public class Compressor
extends ShareableChestButton {
    public Compressor(String string) {
        super(string, "compressor");
        this.build();
    }

    @Override
    protected void build() {
        double d = this.dataManager.getCompressorPrice(this.chestType);
        Material material = this.languages.getGuiCompressorIconMaterial();
        String string = this.languages.getGuiCompressorIconName();
        ArrayList<String> arrayList = new ArrayList<String>(this.languages.getGuiCompressorIconLore());
        String string2 = this.languages.getGuiCompressorIconPriceFormat();
        if (d > 0.0 && this.plugin.getEcon() != null && !string2.isEmpty()) {
            arrayList.add("");
            arrayList.add(string2);
        }
        Object object = this.getItemStack(material, string, this.languages.getGuiCompressorIconHead(), arrayList, this.languages.getGuiCompressorIconCustomModelData());
        object = new BaseShareableButtonItem(this, "main", (ItemStack)object);
        this.addItem(object);
        this.loadPlaceholders();
        ((BaseShareableButtonItem)object).refresh(null);
    }

    @Override
    public void loadActions(ChestInventory chestInventory) {
        BaseChest baseChest = (BaseChest)chestInventory.getChest();
        chestInventory.addAction(new Compressing(baseChest, ClickType.LEFT, this.getSlot(chestInventory)));
    }

    @Override
    protected void loadPlaceholders() {
        for (ShareableButtonItem shareableButtonItem : this.getItems()) {
            shareableButtonItem.addPlaceholder(new ItemPlaceHolder("%price%"){

                @Override
                public String getReplacement() {
                    return FormatUtils.format(Compressor.this.dataManager.getCompressorPrice(Compressor.this.chestType));
                }
            });
        }
    }

    @Override
    public Integer getSlot(@NotNull InteractiveInventory interactiveInventory) {
        return interactiveInventory.getBukkitInventory().getSize() - (10 - this.dataManager.getCompressorSlot(this.chestType));
    }
}

