/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.buttons;

import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.BaseChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.ChestInventory;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.ShareableChestButton;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.actions.Smelting;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.FormatUtils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.ItemPlaceHolder;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.InteractiveInventory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.items.BaseShareableButtonItem;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.items.ShareableButtonItem;

public class Smelter
extends ShareableChestButton {
    public Smelter(String string) {
        super(string, "smelter");
        this.build();
    }

    @Override
    protected void build() {
        double d = this.dataManager.getSmelterPrice(this.chestType);
        Material material = this.languages.getGuiSmelterIconMaterial();
        String string = this.languages.getGuiSmelterIconName();
        ArrayList<String> arrayList = new ArrayList<String>(this.languages.getGuiSmelterIconLore());
        String string2 = this.languages.getGuiSmelterIconPriceFormat();
        if (d > 0.0 && this.plugin.getEcon() != null && !string2.isEmpty()) {
            arrayList.add("");
            arrayList.add(string2);
        }
        Object object = this.getItemStack(material, string, this.languages.getGuiSmelterIconHead(), arrayList, this.languages.getGuiSmelterIconCustomModelData());
        object = new BaseShareableButtonItem(this, "main", (ItemStack)object);
        this.addItem(object);
        this.loadPlaceholders();
        ((BaseShareableButtonItem)object).refresh(null);
    }

    @Override
    public void loadActions(ChestInventory chestInventory) {
        BaseChest baseChest = (BaseChest)chestInventory.getChest();
        chestInventory.addAction(new Smelting(baseChest, ClickType.LEFT, this.getSlot(chestInventory)));
    }

    @Override
    protected void loadPlaceholders() {
        for (ShareableButtonItem shareableButtonItem : this.getItems()) {
            shareableButtonItem.addPlaceholder(new ItemPlaceHolder("%price%"){

                @Override
                public String getReplacement() {
                    return FormatUtils.format(Smelter.this.dataManager.getSmelterPrice(Smelter.this.chestType));
                }
            });
        }
    }

    @Override
    public Integer getSlot(@NotNull InteractiveInventory interactiveInventory) {
        return interactiveInventory.getBukkitInventory().getSize() - (10 - this.dataManager.getSmelterSlot(this.chestType));
    }
}

