/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.listeners;

import org.bukkit.NamespacedKey;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import us.lynuxcraft.deadsilenceiv.advancedchests.AdvancedChestsPlugin;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.ContainerType;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.DataManager;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.ChestsProvider;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.xseries.XMaterial;

public class CraftingHandler
implements Listener {
    private AdvancedChestsPlugin a = AdvancedChestsPlugin.getInstance();
    private DataManager b = this.a.getDataManager();

    @EventHandler
    public void onCraft(CraftItemEvent craftItemEvent) {
        if (this.handleChestCrafting(craftItemEvent)) {
            return;
        }
        this.handleShulkerDyeing(craftItemEvent);
    }

    public boolean handleChestCrafting(CraftItemEvent craftItemEvent) {
        block5: {
            Recipe recipe;
            if (this.a.isNbtApiAvailable() && this.a.getConfiguration().getUseNBTApi() && (recipe = craftItemEvent.getRecipe()) instanceof ShapedRecipe) {
                recipe = (ShapedRecipe)recipe;
                try {
                    NamespacedKey namespacedKey = recipe.getKey();
                    if (namespacedKey.getNamespace().equals("advancedchests")) {
                        craftItemEvent.getInventory().setResult(ChestsProvider.getAdvancedChest(namespacedKey.getKey()));
                    }
                }
                catch (Throwable throwable) {
                    recipe = recipe.getResult();
                    if (!ContainerType.isAContainerItemMaterial(recipe.getType())) break block5;
                    for (String string : this.b.getAdvancedChestNames()) {
                        ItemStack itemStack = this.b.getIcon(string);
                        if (!itemStack.isSimilar((ItemStack)recipe)) continue;
                        craftItemEvent.getInventory().setResult(ChestsProvider.getAdvancedChest(string));
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void handleShulkerDyeing(CraftItemEvent craftItemEvent) {
        CraftingInventory craftingInventory = craftItemEvent.getInventory();
        for (ItemStack itemStack : craftingInventory.getMatrix()) {
            if (itemStack == null || !XMaterial.matchXMaterial(itemStack).name().contains("DYE")) continue;
            for (ItemStack itemStack2 : craftingInventory.getMatrix()) {
                if (ChestsProvider.getAdvancedChestTypeByItem(itemStack2) == null) continue;
                craftItemEvent.setCancelled(true);
                return;
            }
        }
    }
}

