/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.managers.yml;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.configuration.file.YamlConfiguration;
import us.lynuxcraft.deadsilenceiv.advancedchests.AdvancedChestsPlugin;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.AdvancedChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.ChestAttribute;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.ChestType;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.containers.BaseContainer;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.ChestPage;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.ChestStorage;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.FileUtils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.LocationUtils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.Pair;

public class ChestsYamlStorage
implements ChestStorage {
    private AdvancedChestsPlugin a = AdvancedChestsPlugin.getInstance();
    private File b;
    private Map<UUID, Pair<File, YamlConfiguration>> c = new HashMap<UUID, Pair<File, YamlConfiguration>>();

    public ChestsYamlStorage() {
        this.b = new File(this.a.getDataFolder().getPath() + File.separator + "data");
        if (!this.b.exists()) {
            this.b.mkdirs();
        }
        this.a();
    }

    private void a() {
        File[] fileArray = this.b.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (!FileUtils.getFileExtension(file.getName()).equals(".yml")) continue;
                UUID uUID = UUID.fromString(FileUtils.removeExtension(file.getName()));
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
                this.c.put(uUID, new Pair<File, YamlConfiguration>(file, yamlConfiguration));
            }
        }
    }

    @Override
    public void save(AdvancedChest<?, ?> advancedChest) {
        Comparable<UUID> comparable = advancedChest.getUniqueId();
        ChestType chestType = advancedChest.getChestType();
        YamlConfiguration yamlConfiguration = this.a((UUID)comparable);
        if (yamlConfiguration == null) {
            yamlConfiguration = this.b((UUID)comparable);
        }
        comparable = yamlConfiguration.getKey();
        yamlConfiguration = yamlConfiguration.getValue();
        yamlConfiguration.set("size", (Object)advancedChest.getSize());
        if (yamlConfiguration.isSet("type")) {
            yamlConfiguration.set("type", null);
        }
        yamlConfiguration.set("config-type", (Object)advancedChest.getConfigType());
        yamlConfiguration.set("chest-type", (Object)chestType.getName());
        Object object = (BaseContainer)advancedChest.getContainer();
        yamlConfiguration.set("container-type", (Object)((BaseContainer)object).getType().toString());
        yamlConfiguration.set("money", (Object)advancedChest.getMoney());
        yamlConfiguration.set("autosells-status", (Object)advancedChest.isAutomaticSellsStatus());
        object = advancedChest.getAutomaticSellsSessionOwner();
        if (object != null) {
            yamlConfiguration.set("autosells-session-owner", (Object)((UUID)object).toString());
        } else {
            yamlConfiguration.set("autosells-session-owner", null);
        }
        object = advancedChest.getWhoPlaced();
        if (object != null) {
            yamlConfiguration.set("placed-by", (Object)((UUID)object).toString());
        } else {
            yamlConfiguration.set("placed-by", null);
        }
        object = advancedChest.getDirection();
        if (object != null) {
            yamlConfiguration.set("direction", (Object)object.toString());
        } else {
            yamlConfiguration.set("direction", null);
        }
        if (advancedChest.canBeLoaded()) {
            yamlConfiguration.set("location", (Object)LocationUtils.serializeLoc(advancedChest.getLocation()));
            chestType.getYamlService().writePages(yamlConfiguration, advancedChest);
        }
        FileUtils.save((File)comparable, yamlConfiguration);
    }

    @Override
    public void delete(UUID uUID) {
        if (this.c.containsKey(uUID)) {
            File file = this.c.get(uUID).getKey();
            file.delete();
            this.c.remove(uUID);
        }
    }

    @Override
    public CompletableFuture<Map<ChestAttribute, Object>> getChestData(UUID map) {
        if ((map = this.a((UUID)((Object)map))) != null) {
            map = this.a((YamlConfiguration)((Pair)((Object)map)).getValue());
            return CompletableFuture.completedFuture(map);
        }
        return null;
    }

    @Override
    public CompletableFuture<Map<UUID, Map<ChestAttribute, Object>>> getChestsData(Set<UUID> object) {
        HashMap<UUID, Object> hashMap = new HashMap<UUID, Object>();
        object = object.iterator();
        while (object.hasNext()) {
            UUID uUID = (UUID)object.next();
            Pair<File, YamlConfiguration> pair = this.a(uUID);
            if (pair == null) continue;
            pair = this.a(pair.getValue());
            hashMap.put(uUID, pair);
        }
        return CompletableFuture.completedFuture(hashMap);
    }

    private Map<ChestAttribute, Object> a(YamlConfiguration yamlConfiguration) {
        HashMap<ChestAttribute, Object> hashMap = new HashMap<ChestAttribute, Object>();
        hashMap.put(ChestAttribute.LOCATION, yamlConfiguration.getString("location"));
        hashMap.put(ChestAttribute.SIZE, yamlConfiguration.getInt("size"));
        hashMap.put(ChestAttribute.PAGES, this.b(yamlConfiguration));
        if (yamlConfiguration.isSet("type")) {
            hashMap.put(ChestAttribute.CONFIG_TYPE, yamlConfiguration.getString("type"));
        } else {
            hashMap.put(ChestAttribute.CONFIG_TYPE, yamlConfiguration.getString("config-type"));
        }
        ChestType chestType = this.a.getType(yamlConfiguration.getString("chest-type", "NORMAL"));
        hashMap.put(ChestAttribute.CHEST_TYPE, chestType);
        hashMap.put(ChestAttribute.AUTOSELLS_STATUS, yamlConfiguration.getBoolean("autosells-status"));
        hashMap.put(ChestAttribute.AUTOSELLS_SESSION_OWNER, yamlConfiguration.getString("autosells-session-owner"));
        hashMap.put(ChestAttribute.WHO_PLACED, yamlConfiguration.getString("placed-by"));
        hashMap.put(ChestAttribute.MONEY, yamlConfiguration.getDouble("money"));
        hashMap.put(ChestAttribute.DIRECTION, yamlConfiguration.getString("direction"));
        hashMap.put(ChestAttribute.CONTAINER_TYPE, yamlConfiguration.getString("container-type", "CHEST"));
        return hashMap;
    }

    private Map<Integer, ChestPage<?>> b(YamlConfiguration yamlConfiguration) {
        ChestType chestType = this.a.getType(yamlConfiguration.getString("chest-type", "NORMAL"));
        return chestType.getYamlService().getPages(yamlConfiguration);
    }

    private Pair<File, YamlConfiguration> a(UUID uUID) {
        for (UUID uUID2 : this.c.keySet()) {
            if (!uUID2.equals(uUID)) continue;
            return this.c.get(uUID);
        }
        return null;
    }

    private Pair<File, YamlConfiguration> b(UUID uUID) {
        Object object = new File(this.b.getPath() + File.separator + uUID.toString() + ".yml");
        if (!((File)object).exists()) {
            FileUtils.create((File)object);
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)object);
        object = new Pair<File, YamlConfiguration>((File)object, yamlConfiguration);
        this.c.put(uUID, (Pair<File, YamlConfiguration>)object);
        return object;
    }

    @Override
    public CompletableFuture<Set<UUID>> getRegisteredChests() {
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (UUID uUID : this.c.keySet()) {
            Object object = this.c.get(uUID).getValue();
            if ((object = this.a.getType(object.getString("chest-type", "NORMAL"))) == null) continue;
            hashSet.add(uUID);
        }
        return CompletableFuture.completedFuture(hashSet);
    }

    @Override
    public CompletableFuture<Set<UUID>> importData(Map<UUID, Map<ChestAttribute, Object>> map) {
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (UUID uUID : map.keySet()) {
            Object object = map.get(uUID);
            YamlConfiguration yamlConfiguration = this.a(uUID);
            if (yamlConfiguration != null) continue;
            yamlConfiguration = this.b(uUID);
            File file = yamlConfiguration.getKey();
            yamlConfiguration = yamlConfiguration.getValue();
            yamlConfiguration.set("size", object.get((Object)ChestAttribute.SIZE));
            yamlConfiguration.set("config-type", object.get((Object)ChestAttribute.CONFIG_TYPE));
            yamlConfiguration.set("chest-type", (Object)((ChestType)object.get((Object)ChestAttribute.CHEST_TYPE)).getName());
            yamlConfiguration.set("money", object.get((Object)ChestAttribute.MONEY));
            yamlConfiguration.set("autosells-status", object.get((Object)ChestAttribute.AUTOSELLS_STATUS));
            yamlConfiguration.set("autosells-session-owner", object.get((Object)ChestAttribute.AUTOSELLS_SESSION_OWNER));
            yamlConfiguration.set("placed-by", object.get((Object)ChestAttribute.WHO_PLACED));
            yamlConfiguration.set("location", object.get((Object)ChestAttribute.LOCATION));
            yamlConfiguration.set("direction", object.get((Object)ChestAttribute.DIRECTION));
            yamlConfiguration.set("container-type", object.get((Object)ChestAttribute.CONTAINER_TYPE));
            ChestPage<?>[] chestPageArray = this.orderPages((Map)object.get((Object)ChestAttribute.PAGES));
            object = (ChestType)object.get((Object)ChestAttribute.CHEST_TYPE);
            object.getYamlService().writePages(yamlConfiguration, chestPageArray);
            FileUtils.save(file, yamlConfiguration);
            hashSet.add(uUID);
        }
        return CompletableFuture.completedFuture(hashSet);
    }

    @Override
    public void stopServices() {
    }

    public File getFolder() {
        return this.b;
    }

    public Map<UUID, Pair<File, YamlConfiguration>> getData() {
        return this.c;
    }
}

