/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.dispenser;

import org.bukkit.inventory.ItemStack;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.AdvancedChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.NormalChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.ChestPage;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.NormalPage;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.dispenser.DispenserService;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.dispenser.sessions.DispenseSession;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.dispenser.sessions.NormalDispenseSession;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.InventoryUtils;

public class NormalChestDispenser
implements DispenserService {
    @Override
    public ItemStack dispenseLastItemFromChest(AdvancedChest<?, ?> advancedChest, int n) {
        for (int i = advancedChest.getPages().size() - 1; i >= 0; --i) {
            NormalPage normalPage = (NormalPage)((NormalChest)advancedChest).getPageById(i);
            normalPage = normalPage.getBukkitInventory();
            for (int j = normalPage.getSize() - 10; j >= 0; --j) {
                ItemStack itemStack = normalPage.getItem(j);
                if (itemStack == null) continue;
                if (n > 64) {
                    n = 64;
                }
                int n2 = itemStack.getAmount();
                n = Math.min(n, n2);
                ItemStack itemStack2 = itemStack.clone();
                itemStack2.setAmount(n);
                if (n < n2) {
                    itemStack.setAmount(n2 - n);
                } else {
                    normalPage.setItem(j, null);
                }
                return itemStack2;
            }
        }
        return null;
    }

    @Override
    public DispenseSession<?, ?> newDispenseSession(AdvancedChest<?, ?> advancedChest) {
        return new NormalDispenseSession((NormalChest)advancedChest);
    }

    @Override
    public boolean dispenseItemToChest(AdvancedChest<?, ?> advancedChest, ItemStack itemStack) {
        for (int i = 0; i <= advancedChest.getPages().size() - 1; ++i) {
            NormalPage normalPage = (NormalPage)((NormalChest)advancedChest).getPageById(i);
            normalPage = normalPage.getBukkitInventory();
            if (!normalPage.addItem(new ItemStack[]{itemStack}).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSpaceForItem(AdvancedChest<?, ?> object, ItemStack itemStack) {
        for (ChestPage chestPage : object.getPages().values()) {
            if (!InventoryUtils.hasSpaceForItem(chestPage, itemStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getLastItemFromChest(AdvancedChest<?, ?> advancedChest) {
        for (int i = advancedChest.getPages().size() - 1; i >= 0; --i) {
            NormalPage normalPage = (NormalPage)((NormalChest)advancedChest).getPageById(i);
            normalPage = normalPage.getBukkitInventory();
            for (int j = normalPage.getSize() - 10; j >= 0; --j) {
                ItemStack itemStack = normalPage.getItem(j);
                if (itemStack == null) continue;
                return itemStack;
            }
        }
        return null;
    }
}

