/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.storage.yaml;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.AdvancedChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.ChestPage;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.NormalPage;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.storage.yaml.YamlService;

public class NormalPageYamlStorage
implements YamlService {
    @Override
    public void writePages(YamlConfiguration yamlConfiguration, AdvancedChest<?, ?> advancedChest) {
        yamlConfiguration.set("pages", null);
        for (int i = 0; i < advancedChest.getPages().size(); ++i) {
            Object object = advancedChest.getPageById(i);
            object = object.getBukkitInventory();
            for (int j = 0; j <= object.getSize() - 10; ++j) {
                ItemStack itemStack = object.getItem(j);
                if (itemStack == null) continue;
                yamlConfiguration.set("pages." + i + "." + j, (Object)itemStack);
            }
        }
    }

    @Override
    public void writePages(YamlConfiguration yamlConfiguration, ChestPage<?>[] chestPageArray) {
        for (int i = 0; i < chestPageArray.length; ++i) {
            ItemStack[] itemStackArray = (ItemStack[])chestPageArray[i];
            itemStackArray = itemStackArray.getItems();
            for (int j = 0; j < itemStackArray.length; ++j) {
                ItemStack itemStack = itemStackArray[j];
                if (itemStack == null) continue;
                yamlConfiguration.set("pages." + i + "." + j, (Object)itemStack);
            }
        }
    }

    @Override
    public Map<Integer, ? extends ChestPage<?>> getPages(YamlConfiguration yamlConfiguration) {
        HashMap<Integer, NormalPage> hashMap = new HashMap<Integer, NormalPage>();
        ConfigurationSection configurationSection = yamlConfiguration.getConfigurationSection("pages");
        if (configurationSection == null) {
            configurationSection = yamlConfiguration.createSection("pages");
        }
        int n = yamlConfiguration.getInt("size");
        int n2 = (int)Math.ceil((double)n / 45.0);
        for (int i = 0; i <= n2 - 1; ++i) {
            NormalPage normalPage;
            int n3 = 45;
            if (i == n2 - 1 && n % 45 != 0) {
                int n4 = n;
                n3 = n4 - (int)Math.floor((double)n4 / 45.0) * 45;
            }
            if (configurationSection.isConfigurationSection("" + i)) {
                ItemStack[] itemStackArray = new ItemStack[n3];
                for (int j = 0; j <= n3 - 1; ++j) {
                    itemStackArray[j] = configurationSection.isSet(i + "." + j) ? (ItemStack)configurationSection.get(i + "." + j) : null;
                }
                normalPage = new NormalPage(i, itemStackArray, null);
            } else {
                normalPage = new NormalPage(i, new ItemStack[n3], null);
            }
            hashMap.put(i, normalPage);
        }
        return hashMap;
    }
}

