/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.builders;

import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.xseries.XMaterial;

public class ItemBuilder {
    protected ItemStack stack;

    public ItemBuilder(Material material) {
        this.stack = new ItemStack(material);
    }

    public ItemBuilder(ItemStack itemStack) {
        this.stack = itemStack.clone();
    }

    public ItemBuilder() {
    }

    public ItemBuilder setAmount(Integer n) {
        this.stack.setAmount(n.intValue());
        return this;
    }

    public ItemBuilder setDamage(Short s) {
        this.stack.setDurability(s.shortValue());
        return this;
    }

    public ItemBuilder setName(String string) {
        ItemMeta itemMeta = this.stack.getItemMeta();
        itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
        this.stack.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder setLore(List<String> list) {
        if (!list.isEmpty()) {
            for (int i = 0; i <= list.size() - 1; ++i) {
                String string = list.get(i);
                list.set(i, ChatColor.translateAlternateColorCodes((char)'&', (String)string));
            }
        }
        ItemMeta itemMeta = this.stack.getItemMeta();
        itemMeta.setLore(list);
        this.stack.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder setCustomModelData(Integer n) {
        if (n != null && n > 0 && XMaterial.supports(14)) {
            ItemMeta itemMeta = this.stack.getItemMeta();
            itemMeta.setCustomModelData(n);
            this.stack.setItemMeta(itemMeta);
        }
        return this;
    }

    public ItemBuilder addEnchantment(Enchantment enchantment, Integer n, boolean bl) {
        if (bl) {
            this.stack.addUnsafeEnchantment(enchantment, n.intValue());
        } else {
            this.stack.addEnchantment(enchantment, n.intValue());
        }
        return this;
    }

    private ItemBuilder a(ItemFlag ... itemFlagArray) {
        ItemMeta itemMeta = this.stack.getItemMeta();
        itemMeta.addItemFlags(itemFlagArray);
        this.stack.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder addEnchantments(Map<Enchantment, Integer> map, boolean bl) {
        if (bl) {
            this.stack.addUnsafeEnchantments(map);
        } else {
            this.stack.addEnchantments(map);
        }
        return this;
    }

    public ItemStack build() {
        return this.stack;
    }
}

