/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.metrics.dropwizard;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.HikariConfig;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool.HikariPool;

public final class CodahaleHealthChecker {
    public static void registerHealthChecks(HikariPool object, HikariConfig hikariConfig, HealthCheckRegistry healthCheckRegistry) {
        Properties properties = hikariConfig.getHealthCheckProperties();
        MetricRegistry metricRegistry = (MetricRegistry)hikariConfig.getMetricRegistry();
        long l = Long.parseLong(properties.getProperty("connectivityCheckTimeoutMs", String.valueOf(hikariConfig.getConnectionTimeout())));
        healthCheckRegistry.register(MetricRegistry.name((String)hikariConfig.getPoolName(), (String[])new String[]{"pool", "ConnectivityCheck"}), (HealthCheck)new ConnectivityHealthCheck((HikariPool)object, l));
        long l2 = Long.parseLong(properties.getProperty("expected99thPercentileMs", "0"));
        if (metricRegistry != null && l2 > 0L && !(object = metricRegistry.getTimers((string, metric) -> string.equals(MetricRegistry.name((String)hikariConfig.getPoolName(), (String[])new String[]{"pool", "Wait"})))).isEmpty()) {
            object = (Timer)object.entrySet().iterator().next().getValue();
            healthCheckRegistry.register(MetricRegistry.name((String)hikariConfig.getPoolName(), (String[])new String[]{"pool", "Connection99Percent"}), (HealthCheck)new Connection99Percent((Timer)object, l2));
        }
    }

    private CodahaleHealthChecker() {
    }

    private static class Connection99Percent
    extends HealthCheck {
        private final Timer a;
        private final long b;

        Connection99Percent(Timer timer, long l) {
            this.a = timer;
            this.b = l;
        }

        protected HealthCheck.Result check() {
            long l = TimeUnit.NANOSECONDS.toMillis(Math.round(this.a.getSnapshot().get99thPercentile()));
            if (l <= this.b) {
                return HealthCheck.Result.healthy();
            }
            return HealthCheck.Result.unhealthy((String)"99th percentile connection wait time of %dms exceeds the threshold %dms", (Object[])new Object[]{l, this.b});
        }
    }

    private static class ConnectivityHealthCheck
    extends HealthCheck {
        private final HikariPool a;
        private final long b;

        ConnectivityHealthCheck(HikariPool hikariPool, long l) {
            this.a = hikariPool;
            this.b = l > 0L && l != Integer.MAX_VALUE ? l : TimeUnit.SECONDS.toMillis(10L);
        }

        protected HealthCheck.Result check() {
            HealthCheck.Result result;
            block8: {
                Object object = this.a.getConnection(this.b);
                try {
                    result = HealthCheck.Result.healthy();
                    if (object == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (object != null) {
                            try {
                                object.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException sQLException) {
                        object = sQLException;
                        return HealthCheck.Result.unhealthy((Throwable)sQLException);
                    }
                }
                object.close();
            }
            return result;
        }
    }
}

