/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.metrics.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Summary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.metrics.IMetricsTracker;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.metrics.prometheus.HikariCPCollector;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.metrics.prometheus.PrometheusMetricsTrackerFactory;

class PrometheusMetricsTracker
implements IMetricsTracker {
    private static final Counter a = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("hikaricp_connection_timeout_total")).labelNames(new String[]{"pool"})).help("Connection timeout total count")).create();
    private static final Summary b = PrometheusMetricsTracker.a("hikaricp_connection_acquired_nanos", "Connection acquired time (ns)");
    private static final Summary c = PrometheusMetricsTracker.a("hikaricp_connection_usage_millis", "Connection usage (ms)");
    private static final Summary d = PrometheusMetricsTracker.a("hikaricp_connection_creation_millis", "Connection creation (ms)");
    private static final Map<CollectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus> e = new ConcurrentHashMap<CollectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus>();
    private final String f;
    private final HikariCPCollector g;
    private final Counter.Child h;
    private final Summary.Child i;
    private final Summary.Child j;
    private final Summary.Child k;

    PrometheusMetricsTracker(String string, CollectorRegistry collectorRegistry, HikariCPCollector hikariCPCollector) {
        if (e.putIfAbsent(collectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus.REGISTERED) == null) {
            a.register(collectorRegistry);
            b.register(collectorRegistry);
            c.register(collectorRegistry);
            d.register(collectorRegistry);
        }
        this.f = string;
        this.g = hikariCPCollector;
        this.h = (Counter.Child)a.labels(new String[]{string});
        this.i = (Summary.Child)b.labels(new String[]{string});
        this.j = (Summary.Child)c.labels(new String[]{string});
        this.k = (Summary.Child)d.labels(new String[]{string});
    }

    private static void a(CollectorRegistry collectorRegistry) {
        if (e.putIfAbsent(collectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus.REGISTERED) == null) {
            a.register(collectorRegistry);
            b.register(collectorRegistry);
            c.register(collectorRegistry);
            d.register(collectorRegistry);
        }
    }

    @Override
    public void recordConnectionAcquiredNanos(long l) {
        this.i.observe((double)l);
    }

    @Override
    public void recordConnectionUsageMillis(long l) {
        this.j.observe((double)l);
    }

    @Override
    public void recordConnectionCreatedMillis(long l) {
        this.k.observe((double)l);
    }

    @Override
    public void recordConnectionTimeout() {
        this.h.inc();
    }

    private static Summary a(String string, String string2) {
        return ((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name(string)).labelNames(new String[]{"pool"})).help(string2)).quantile(0.5, 0.05).quantile(0.95, 0.01).quantile(0.99, 0.001).maxAgeSeconds(TimeUnit.MINUTES.toSeconds(5L)).ageBuckets(5).create();
    }

    @Override
    public void close() {
        this.g.remove(this.f);
        a.remove(new String[]{this.f});
        b.remove(new String[]{this.f});
        c.remove(new String[]{this.f});
        d.remove(new String[]{this.f});
    }
}

