/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbBlob;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.exceptions.ExceptionFactory;

public class MariaDbClob
extends MariaDbBlob
implements Serializable,
Clob,
NClob {
    private static final long a = -3066501059817815286L;

    public MariaDbClob(byte[] byArray) {
        super(byArray);
    }

    public MariaDbClob(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
    }

    public MariaDbClob() {
    }

    public String toString() {
        return new String(this.data, this.offset, this.length, StandardCharsets.UTF_8);
    }

    @Override
    public String getSubString(long l, int n) {
        if (l < 1L) {
            throw ExceptionFactory.INSTANCE.create("position must be >= 1");
        }
        if (n < 0) {
            throw ExceptionFactory.INSTANCE.create("length must be > 0");
        }
        try {
            String string = this.toString();
            return string.substring((int)l - 1, Math.min((int)l - 1 + n, string.length()));
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public Reader getCharacterStream() {
        return new StringReader(this.toString());
    }

    @Override
    public Reader getCharacterStream(long l, long l2) {
        String string = this.toString();
        if ((long)string.length() < (long)((int)l - 1) + l2) {
            throw ExceptionFactory.INSTANCE.create("pos + length is greater than the number of characters in the Clob");
        }
        String string2 = string.substring((int)l - 1, (int)l - 1 + (int)l2);
        return new StringReader(string2);
    }

    @Override
    public Writer setCharacterStream(long l) {
        int n = this.a((int)l - 1);
        OutputStream outputStream = this.setBinaryStream(n + 1);
        return new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
    }

    @Override
    public InputStream getAsciiStream() {
        return this.getBinaryStream();
    }

    @Override
    public long position(String string, long l) {
        return this.toString().indexOf(string, (int)l - 1) + 1;
    }

    @Override
    public long position(Clob clob, long l) {
        return this.position(clob.toString(), l);
    }

    private int a(int n) {
        int n2 = this.offset;
        for (int i = 0; i < n; ++i) {
            int n3 = this.data[n2] & 0xFF;
            if (n3 < 128) {
                ++n2;
                continue;
            }
            if (n3 < 194) {
                throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
            }
            if (n3 < 224) {
                n2 += 2;
                continue;
            }
            if (n3 < 240) {
                n2 += 3;
                continue;
            }
            if (n3 < 248) {
                n2 += 4;
                continue;
            }
            throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
        }
        return n2;
    }

    @Override
    public int setString(long l, String string) {
        int n = this.a((int)l - 1);
        super.setBytes(n + 1 - this.offset, string.getBytes(StandardCharsets.UTF_8));
        return string.length();
    }

    @Override
    public int setString(long l, String string, int n, int n2) {
        int n3 = n;
        return this.setString(l, string.substring(n3, n3 + n2));
    }

    @Override
    public OutputStream setAsciiStream(long l) {
        MariaDbClob mariaDbClob = this;
        return mariaDbClob.setBinaryStream(mariaDbClob.a((int)l - 1) + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long length() {
        long l = 0L;
        int n = this.offset;
        while (l < (long)this.length && this.data[n] >= 0) {
            ++l;
            ++n;
        }
        while (n < this.offset + this.length) {
            byte by;
            if ((by = this.data[n++]) < 0) {
                if (by >> 5 != -2 || (by & 0x1E) == 0) {
                    if (by >> 4 == -2) {
                        if (n + 1 >= this.offset + this.length) throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
                        n += 2;
                    } else {
                        if (by >> 3 != -2) {
                            throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
                        }
                        if (n + 2 < this.offset + this.length) {
                            n += 3;
                            l += 2L;
                            continue;
                        }
                        n += this.offset + this.length;
                    }
                } else {
                    ++n;
                }
            }
            ++l;
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void truncate(long l) {
        long l2;
        int n = this.offset;
        for (l2 = 0L; l2 < (long)this.length && l2 < l && this.data[n] >= 0; ++l2, ++n) {
        }
        while (n < this.offset + this.length && l2 < l) {
            block10: {
                byte by;
                if ((by = this.data[n++]) < 0) {
                    if (by >> 5 != -2 || (by & 0x1E) == 0) {
                        if (by >> 4 == -2) {
                            if (n + 1 >= this.offset + this.length) {
                                throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
                            }
                            n += 2;
                            break block10;
                        } else {
                            if (by >> 3 != -2) {
                                throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
                            }
                            if (n + 2 >= this.offset + this.length) {
                                throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
                            }
                            if (l2 + 2L <= l) {
                                n += 3;
                                l2 += 2L;
                                continue;
                            }
                            ++n;
                            l2 = l;
                            continue;
                        }
                    }
                    ++n;
                }
            }
            ++l2;
        }
        this.length = n - this.offset;
    }
}

