/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb;

import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.HostAddress;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbConnection;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbPooledConnection;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaXaConnection;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.UrlParser;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.constant.HaMode;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.exceptions.ExceptionFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.pool.Pool;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.pool.Pools;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.DefaultOptions;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public class MariaDbPoolDataSource
implements Closeable,
AutoCloseable,
ConnectionPoolDataSource,
DataSource,
XADataSource {
    private UrlParser a;
    private Pool b;
    private String c;
    private Integer d;
    private Integer e;
    private String f;
    private String g;
    private String h;
    private String i;
    private String j;
    private Integer k;
    private Integer l;
    private Integer m;
    private Boolean n;
    private Integer o;

    public MariaDbPoolDataSource(String string, int n, String string2) {
        this.c = string;
        this.d = n;
        this.f = string2;
    }

    public MariaDbPoolDataSource(String string) {
        this.g = string;
    }

    public MariaDbPoolDataSource() {
    }

    public String getDatabaseName() {
        if (this.f != null) {
            return this.f;
        }
        if (this.a != null && this.a.getDatabase() != null) {
            return this.a.getDatabase();
        }
        return "";
    }

    public void setDatabaseName(String string) {
        this.a();
        this.f = string;
    }

    private void a() {
        if (this.b != null) {
            throw new SQLException("can not perform a configuration change once initialized");
        }
    }

    public String getUser() {
        if (this.h != null) {
            return this.h;
        }
        if (this.a != null) {
            return this.a.getUsername();
        }
        return null;
    }

    public void setUser(String string) {
        this.a();
        this.h = string;
    }

    public void setPassword(String string) {
        this.a();
        this.i = string;
    }

    public int getPort() {
        if (this.d != null && this.d != 0) {
            return this.d;
        }
        if (this.a != null) {
            return this.a.getHostAddresses().get((int)0).port;
        }
        return 3306;
    }

    public void setPort(int n) {
        this.a();
        this.d = n;
    }

    public int getPortNumber() {
        return this.getPort();
    }

    public void setPortNumber(int n) {
        this.a();
        if (n > 0) {
            this.setPort(n);
        }
    }

    public void setUrl(String string) {
        this.a();
        this.g = string;
    }

    public String getServerName() {
        if (this.c != null) {
            return this.c;
        }
        boolean bl = this.a != null && this.a.getHostAddresses().get((int)0).host != null;
        if (bl) {
            return this.a.getHostAddresses().get((int)0).host;
        }
        return "localhost";
    }

    public void setServerName(String string) {
        this.a();
        this.c = string;
    }

    @Override
    public Connection getConnection() {
        try {
            if (this.b == null) {
                this.initialize();
            }
            return this.b.getConnection();
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.INSTANCE.create(sQLException);
        }
    }

    @Override
    public Connection getConnection(String string, String string2) {
        try {
            if (this.b == null) {
                this.h = string;
                this.i = string2;
                this.initialize();
                return this.b.getConnection();
            }
            if ((this.a.getUsername() != null ? this.a.getUsername().equals(string) : string == null) && (this.a.getPassword() != null ? this.a.getPassword().equals(string2) : string2 == null || string2.isEmpty())) {
                return this.b.getConnection();
            }
            UrlParser urlParser = (UrlParser)this.a.clone();
            urlParser.setUsername(string);
            urlParser.setPassword(string2);
            return MariaDbConnection.newConnection(urlParser, this.b.getGlobalInfo());
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.INSTANCE.create(sQLException);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new SQLException("Error in configuration");
        }
    }

    @Override
    public PooledConnection getPooledConnection() {
        return new MariaDbPooledConnection((MariaDbConnection)this.getConnection());
    }

    @Override
    public PooledConnection getPooledConnection(String string, String string2) {
        return new MariaDbPooledConnection((MariaDbConnection)this.getConnection(string, string2));
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
    }

    @Override
    public int getLoginTimeout() {
        if (this.e != null) {
            return this.e / 1000;
        }
        if (this.a != null) {
            return this.a.getOptions().connectTimeout / 1000;
        }
        return 0;
    }

    @Override
    public void setLoginTimeout(int n) {
        this.a();
        this.e = n * 1000;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        try {
            if (this.isWrapperFor(clazz)) {
                return clazz.cast(this);
            }
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
        catch (Exception exception) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz.isInstance(this);
    }

    @Override
    public XAConnection getXAConnection() {
        return new MariaXaConnection((MariaDbConnection)this.getConnection());
    }

    @Override
    public XAConnection getXAConnection(String string, String string2) {
        return new MariaXaConnection((MariaDbConnection)this.getConnection(string, string2));
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    protected UrlParser getUrlParser() {
        return this.a;
    }

    public String getPoolName() {
        if (this.b != null) {
            return this.b.getPoolTag();
        }
        return this.j;
    }

    public void setPoolName(String string) {
        this.a();
        this.j = string;
    }

    public int getMaxPoolSize() {
        if (this.k == null) {
            return 8;
        }
        return this.k;
    }

    public void setMaxPoolSize(int n) {
        this.a();
        this.k = n;
    }

    public int getMinPoolSize() {
        if (this.l == null) {
            return this.getMaxPoolSize();
        }
        return this.l;
    }

    public void setMinPoolSize(int n) {
        this.a();
        this.l = n;
    }

    public int getMaxIdleTime() {
        if (this.m == null) {
            return 600;
        }
        return this.m;
    }

    public void setMaxIdleTime(int n) {
        this.a();
        this.m = n;
    }

    public Boolean getStaticGlobal() {
        return this.n;
    }

    public void setStaticGlobal(Boolean bl) {
        this.n = bl;
    }

    public Integer getPoolValidMinDelay() {
        if (this.o == null) {
            return 1000;
        }
        return this.o;
    }

    public void setPoolValidMinDelay(Integer n) {
        this.o = n;
    }

    private synchronized void b() {
        if (this.g != null && !this.g.isEmpty()) {
            Properties properties = new Properties();
            properties.setProperty("pool", "true");
            if (this.h != null) {
                properties.setProperty("user", this.h);
            }
            if (this.i != null) {
                properties.setProperty("password", this.i);
            }
            if (this.j != null) {
                properties.setProperty("poolName", this.j);
            }
            if (this.f != null) {
                properties.setProperty("database", this.f);
            }
            if (this.k != null) {
                properties.setProperty("maxPoolSize", String.valueOf(this.k));
            }
            if (this.l != null) {
                properties.setProperty("minPoolSize", String.valueOf(this.l));
            }
            if (this.m != null) {
                properties.setProperty("maxIdleTime", String.valueOf(this.m));
            }
            if (this.e != null) {
                properties.setProperty("connectTimeout", String.valueOf(this.e));
            }
            if (this.n != null) {
                properties.setProperty("staticGlobal", String.valueOf(this.n));
            }
            if (this.o != null) {
                properties.setProperty("poolValidMinDelay", String.valueOf(this.o));
            }
            this.a = UrlParser.parse(this.g, properties);
            return;
        }
        Options options = DefaultOptions.defaultValues(HaMode.NONE);
        DefaultOptions.defaultValues(HaMode.NONE).pool = true;
        options.user = this.h;
        options.password = this.i;
        options.poolName = this.j;
        if (this.k != null) {
            options.maxPoolSize = this.k;
        }
        if (this.l != null) {
            options.minPoolSize = this.l;
        }
        if (this.m != null) {
            options.maxIdleTime = this.m;
        }
        if (this.n != null) {
            options.staticGlobal = this.n;
        }
        if (this.e != null) {
            options.connectTimeout = this.e;
        }
        if (this.o != null) {
            options.poolValidMinDelay = this.o;
        }
        this.a = new UrlParser(this.f, Collections.singletonList(new HostAddress(this.c == null || this.c.isEmpty() ? "localhost" : this.c, this.d == null ? 3306 : this.d)), options, HaMode.NONE);
    }

    @Override
    public void close() {
        try {
            if (this.b != null) {
                this.b.close();
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public synchronized void initialize() {
        if (this.b == null) {
            this.b();
            this.b = Pools.retrievePool(this.a);
        }
    }

    public List<Long> testGetConnectionIdleThreadIds() {
        return this.b.testGetConnectionIdleThreadIds();
    }

    public void testForceMaxIdleTime(int n) {
        this.b();
        this.a.getOptions().maxIdleTime = n;
        this.b = Pools.retrievePool(this.a);
    }

    public Pool testGetPool() {
        return this.b;
    }
}

