/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbConnection;

public class MariaDbPooledConnection
implements PooledConnection {
    private final MariaDbConnection a;
    private final List<ConnectionEventListener> b;
    private final List<StatementEventListener> c;
    private final AtomicLong d;

    public MariaDbPooledConnection(MariaDbConnection mariaDbConnection) {
        this.a = mariaDbConnection;
        mariaDbConnection.pooledConnection = this;
        this.c = new CopyOnWriteArrayList<StatementEventListener>();
        this.b = new CopyOnWriteArrayList<ConnectionEventListener>();
        this.d = new AtomicLong(System.nanoTime());
    }

    @Override
    public MariaDbConnection getConnection() {
        return this.a;
    }

    @Override
    public void close() {
        this.a.pooledConnection = null;
        this.a.close();
    }

    public void abort(Executor executor) {
        this.a.pooledConnection = null;
        this.a.abort(executor);
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.b.add(connectionEventListener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.b.remove(connectionEventListener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        this.c.add(statementEventListener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        this.c.remove(statementEventListener);
    }

    public void fireStatementClosed(Statement object) {
        if (object instanceof PreparedStatement) {
            object = new StatementEvent(this, (PreparedStatement)object);
            for (StatementEventListener statementEventListener : this.c) {
                statementEventListener.statementClosed((StatementEvent)object);
            }
        }
    }

    public void fireStatementErrorOccured(Statement object, SQLException object2) {
        if (object instanceof PreparedStatement) {
            object = new StatementEvent(this, (PreparedStatement)object, (SQLException)object2);
            for (StatementEventListener statementEventListener : this.c) {
                statementEventListener.statementErrorOccurred((StatementEvent)object);
            }
        }
    }

    public void fireConnectionClosed() {
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        for (ConnectionEventListener connectionEventListener : this.b) {
            connectionEventListener.connectionClosed(connectionEvent);
        }
    }

    public void fireConnectionErrorOccured(SQLException serializable) {
        serializable = new ConnectionEvent(this, (SQLException)serializable);
        for (ConnectionEventListener connectionEventListener : this.b) {
            connectionEventListener.connectionErrorOccurred((ConnectionEvent)serializable);
        }
    }

    public boolean noStmtEventListeners() {
        return this.c.isEmpty();
    }

    public AtomicLong getLastUsed() {
        return this.d;
    }

    public void lastUsedToNow() {
        this.d.set(System.nanoTime());
    }
}

