/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbConnection;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbXid;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.Utils;

public class MariaXaResource
implements XAResource {
    private final MariaDbConnection a;

    public MariaXaResource(MariaDbConnection mariaDbConnection) {
        this.a = mariaDbConnection;
    }

    protected static String xidToString(Xid xid) {
        return "0x" + Utils.byteArrayToHexString(xid.getGlobalTransactionId()) + ",0x" + Utils.byteArrayToHexString(xid.getBranchQualifier()) + ",0x" + Integer.toHexString(xid.getFormatId());
    }

    private static String a(int n) {
        switch (n) {
            case 0x200000: {
                return "JOIN";
            }
            case 0x40000000: {
                return "ONE PHASE";
            }
            case 0x8000000: {
                return "RESUME";
            }
            case 0x2000000: {
                return "SUSPEND";
            }
        }
        return "";
    }

    private static XAException a(SQLException sQLException) {
        int n;
        switch (sQLException.getErrorCode()) {
            case 1397: {
                n = -4;
                break;
            }
            case 1398: {
                n = -5;
                break;
            }
            case 1399: {
                n = -7;
                break;
            }
            case 1400: {
                n = -9;
                break;
            }
            case 1401: {
                n = -3;
                break;
            }
            case 1402: {
                n = 100;
                break;
            }
            default: {
                n = 0;
            }
        }
        XAException xAException = n != 0 ? new XAException(n) : new XAException(sQLException.getMessage());
        xAException.initCause(sQLException);
        return xAException;
    }

    private void a(String object) {
        try {
            this.a.createStatement().execute((String)object);
            return;
        }
        catch (SQLException sQLException) {
            object = sQLException;
            throw MariaXaResource.a(sQLException);
        }
    }

    @Override
    public void commit(Xid object, boolean bl) {
        object = "XA COMMIT " + MariaXaResource.xidToString((Xid)object);
        if (bl) {
            object = (String)object + " ONE PHASE";
        }
        this.a((String)object);
    }

    @Override
    public void end(Xid xid, int n) {
        if (n != 0x4000000 && n != 0x2000000 && n != 0x20000000) {
            throw new XAException(-5);
        }
        this.a("XA END " + MariaXaResource.xidToString(xid) + " " + MariaXaResource.a(n));
    }

    @Override
    public void forget(Xid xid) {
    }

    @Override
    public int getTransactionTimeout() {
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xAResource) {
        if (xAResource instanceof MariaXaResource) {
            xAResource = (MariaXaResource)xAResource;
            return this.a.getProtocol().getUrlParser().equals(((MariaXaResource)xAResource).a.getProtocol().getUrlParser());
        }
        return false;
    }

    @Override
    public int prepare(Xid xid) {
        this.a("XA PREPARE " + MariaXaResource.xidToString(xid));
        return 0;
    }

    @Override
    public Xid[] recover(int n) {
        if ((n & 0x1000000) == 0 && (n & 0x800000) == 0 && n != 0) {
            throw new XAException(-5);
        }
        if ((n & 0x1000000) == 0) {
            return new MariaDbXid[0];
        }
        try {
            ResultSet resultSet = this.a.createStatement().executeQuery("XA RECOVER");
            ArrayList<MariaDbXid> arrayList = new ArrayList<MariaDbXid>();
            while (resultSet.next()) {
                int n2 = resultSet.getInt(1);
                int n3 = resultSet.getInt(2);
                int n4 = resultSet.getInt(3);
                byte[] byArray = resultSet.getBytes(4);
                byte[] byArray2 = new byte[n3];
                byte[] byArray3 = new byte[n4];
                System.arraycopy(byArray, 0, byArray2, 0, n3);
                System.arraycopy(byArray, n3, byArray3, 0, n4);
                arrayList.add(new MariaDbXid(n2, byArray2, byArray3));
            }
            Xid[] xidArray = new Xid[arrayList.size()];
            arrayList.toArray(xidArray);
            return xidArray;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            throw MariaXaResource.a(sQLException);
        }
    }

    @Override
    public void rollback(Xid xid) {
        this.a("XA ROLLBACK " + MariaXaResource.xidToString(xid));
    }

    @Override
    public boolean setTransactionTimeout(int n) {
        return false;
    }

    @Override
    public void start(Xid xid, int n) {
        if (n != 0x200000 && n != 0x8000000 && n != 0) {
            throw new XAException(-5);
        }
        this.a("XA START " + MariaXaResource.xidToString(xid) + " " + MariaXaResource.a(n == 0x200000 && this.a.getPinGlobalTxToPhysicalConnection() ? 0x8000000 : n));
    }
}

