/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class Buffer {
    public byte[] buf;
    public int position;
    public int limit;

    public Buffer(byte[] byArray, int n) {
        this.buf = byArray;
        this.limit = n;
    }

    public Buffer(byte[] byArray) {
        this.buf = byArray;
        this.limit = this.buf.length;
    }

    public int remaining() {
        return this.limit - this.position;
    }

    public String readStringNullEnd(Charset charset) {
        int n = this.position;
        int n2 = 0;
        while (this.remaining() > 0 && this.buf[this.position++] != 0) {
            ++n2;
        }
        return new String(this.buf, n, n2, charset);
    }

    public byte[] readBytesNullEnd() {
        int n = this.position;
        int n2 = 0;
        while (this.remaining() > 0 && this.buf[this.position++] != 0) {
            ++n2;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.buf, n, byArray, 0, n2);
        return byArray;
    }

    public String readStringLengthEncoded(Charset object) {
        int n = (int)this.getLengthEncodedNumeric();
        object = new String(this.buf, this.position, n, (Charset)object);
        this.position += n;
        return object;
    }

    public String readString(int n) {
        this.position += n;
        return new String(this.buf, this.position - n, n);
    }

    public short readShort() {
        return (short)((this.buf[this.position++] & 0xFF) + ((this.buf[this.position++] & 0xFF) << 8));
    }

    public int read24bitword() {
        return (this.buf[this.position++] & 0xFF) + ((this.buf[this.position++] & 0xFF) << 8) + ((this.buf[this.position++] & 0xFF) << 16);
    }

    public int readInt() {
        return (this.buf[this.position++] & 0xFF) + ((this.buf[this.position++] & 0xFF) << 8) + ((this.buf[this.position++] & 0xFF) << 16) + ((this.buf[this.position++] & 0xFF) << 24);
    }

    public long readLong() {
        return (long)(this.buf[this.position++] & 0xFF) + ((long)(this.buf[this.position++] & 0xFF) << 8) + ((long)(this.buf[this.position++] & 0xFF) << 16) + ((long)(this.buf[this.position++] & 0xFF) << 24) + ((long)(this.buf[this.position++] & 0xFF) << 32) + ((long)(this.buf[this.position++] & 0xFF) << 40) + ((long)(this.buf[this.position++] & 0xFF) << 48) + ((long)(this.buf[this.position++] & 0xFF) << 56);
    }

    public byte readByte() {
        return this.buf[this.position++];
    }

    public byte getByte() {
        return this.buf[this.position];
    }

    public byte[] readRawBytes(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf, this.position, byArray, 0, n);
        this.position += n;
        return byArray;
    }

    public void skipByte() {
        ++this.position;
    }

    public void skipBytes(int n) {
        this.position += n;
    }

    public void skipLengthEncodedBytes() {
        int n = this.buf[this.position++] & 0xFF;
        switch (n) {
            case 251: {
                return;
            }
            case 252: {
                this.position += 2 + (0xFFFF & (this.buf[this.position] & 0xFF) + ((this.buf[this.position + 1] & 0xFF) << 8));
                return;
            }
            case 253: {
                this.position += 3 + (0xFFFFFF & (this.buf[this.position] & 0xFF) + ((this.buf[this.position + 1] & 0xFF) << 8) + ((this.buf[this.position + 2] & 0xFF) << 16));
                return;
            }
            case 254: {
                this.position = (int)((long)this.position + (8L + ((long)(this.buf[this.position] & 0xFF) + ((long)(this.buf[this.position + 1] & 0xFF) << 8) + ((long)(this.buf[this.position + 2] & 0xFF) << 16) + ((long)(this.buf[this.position + 3] & 0xFF) << 24) + ((long)(this.buf[this.position + 4] & 0xFF) << 32) + ((long)(this.buf[this.position + 5] & 0xFF) << 40) + ((long)(this.buf[this.position + 6] & 0xFF) << 48) + ((long)(this.buf[this.position + 7] & 0xFF) << 56))));
                return;
            }
        }
        this.position += n;
    }

    public long getLengthEncodedNumeric() {
        int n = this.buf[this.position++] & 0xFF;
        switch (n) {
            case 251: {
                return -1L;
            }
            case 252: {
                return 0xFFFF & this.readShort();
            }
            case 253: {
                return 0xFFFFFF & this.read24bitword();
            }
            case 254: {
                return this.readLong();
            }
        }
        return n;
    }

    public void skipLengthEncodedNumeric() {
        int n = this.buf[this.position++] & 0xFF;
        switch (n) {
            case 252: {
                this.position += 2;
                return;
            }
            case 253: {
                this.position += 3;
                return;
            }
            case 254: {
                this.position += 8;
                return;
            }
        }
    }

    public Buffer getLengthEncodedBuffer() {
        return new Buffer(this.getLengthEncodedBytes());
    }

    public byte[] getLengthEncodedBytes() {
        int n = this.buf[this.position++] & 0xFF;
        switch (n) {
            case 251: {
                return null;
            }
            case 252: {
                n = 0xFFFF & this.readShort();
                break;
            }
            case 253: {
                n = 0xFFFFFF & this.read24bitword();
                break;
            }
            case 254: {
                n = (int)((long)(this.buf[this.position++] & 0xFF) + ((long)(this.buf[this.position++] & 0xFF) << 8) + ((long)(this.buf[this.position++] & 0xFF) << 16) + ((long)(this.buf[this.position++] & 0xFF) << 24) + ((long)(this.buf[this.position++] & 0xFF) << 32) + ((long)(this.buf[this.position++] & 0xFF) << 40) + ((long)(this.buf[this.position++] & 0xFF) << 48) + ((long)(this.buf[this.position++] & 0xFF) << 56));
                break;
            }
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf, this.position, byArray, 0, n);
        this.position += n;
        return byArray;
    }

    public byte getByteAt(int n) {
        return this.buf[n];
    }

    public void writeStringLength(String object) {
        byte[] byArray = ((String)object).getBytes(StandardCharsets.UTF_8);
        object = byArray;
        int n = byArray.length;
        while (this.remaining() < n + 9) {
            this.a();
        }
        this.writeLength(n);
        System.arraycopy(object, 0, this.buf, this.position, n);
        this.position += n;
    }

    public void writeStringLength(byte[] byArray) {
        int n = byArray.length;
        while (this.remaining() < n + 9) {
            this.a();
        }
        this.writeLength(n);
        System.arraycopy(byArray, 0, this.buf, this.position, n);
        this.position += n;
    }

    public void writeStringSmallLength(byte[] byArray) {
        int n = byArray.length;
        while (this.remaining() < n + 1) {
            this.a();
        }
        this.buf[this.position++] = (byte)n;
        System.arraycopy(byArray, 0, this.buf, this.position, n);
        this.position += n;
    }

    public void writeBytes(byte by, byte[] byArray) {
        int n = byArray.length;
        while (this.remaining() < n + 10) {
            this.a();
        }
        this.writeLength(n + 1);
        this.buf[this.position++] = by;
        System.arraycopy(byArray, 0, this.buf, this.position, n);
        this.position += n;
    }

    public void writeLength(long l) {
        if (l < 251L) {
            this.buf[this.position++] = (byte)l;
            return;
        }
        if (l < 65536L) {
            this.buf[this.position++] = -4;
            this.buf[this.position++] = (byte)l;
            this.buf[this.position++] = (byte)(l >>> 8);
            return;
        }
        if (l < 0x1000000L) {
            this.buf[this.position++] = -3;
            this.buf[this.position++] = (byte)l;
            this.buf[this.position++] = (byte)(l >>> 8);
            this.buf[this.position++] = (byte)(l >>> 16);
            return;
        }
        this.buf[this.position++] = -2;
        this.buf[this.position++] = (byte)l;
        this.buf[this.position++] = (byte)(l >>> 8);
        this.buf[this.position++] = (byte)(l >>> 16);
        this.buf[this.position++] = (byte)(l >>> 24);
        this.buf[this.position++] = (byte)(l >>> 32);
        this.buf[this.position++] = (byte)(l >>> 40);
        this.buf[this.position++] = (byte)(l >>> 48);
        this.buf[this.position++] = (byte)(l >>> 54);
    }

    private void a() {
        int n = this.buf.length + (this.buf.length >> 1);
        if (n - 0x7FFFFFF7 > 0) {
            n = 0x7FFFFFF7;
        }
        this.buf = Arrays.copyOf(this.buf, n);
        this.limit = n;
    }
}

